/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * systems.h: Lists of defines for systems
 * 
 * This sets what general flavor the system is (UNIX, etc.), 
 * and defines what extra functions your particular system needs.
 */


#ifndef SYSTEMS_H
#define SYSTEMS_H

#include <string.h>


#define DAEMON_ANY

#ifdef XP_WIN32
#define DAEMON_LISTEN_SIZE 100
#define NSAPI_PUBLIC __declspec(dllexport)
#else
#ifdef AIX
/* AIX can handle really big shoes */
#define DAEMON_LISTEN_SIZE 4096
#else
#define DAEMON_LISTEN_SIZE 128
#endif
#define NSAPI_PUBLIC
#endif

#ifndef MCC_ADMSERV
#define DAEMON_STATS
#endif
#define DAEMON_STATS

#if defined(BSDI)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define FILE_UNIX
#define DNS_CACHE
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define BSD_FLOCK
#define BSD_RLIMIT
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS (MAP_FILE | MAP_PRIVATE)
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#define BSD_SIGNALS
#define BSD_TIME
#define BSD_MAIL
#define AUTH_DBM
#define SEM_FLOCK
#undef NEED_CRYPT_PROTO
#define HAVE_ATEXIT
#define NO_DOMAINNAME
#define HAS_STATFS
#define JAVA_STATIC_LINK
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW

#define ZERO(ptr,len) memset(ptr,0,len)

#elif defined(LINUX)
 
#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#define BSD_RLIMIT
#undef BSD_SIGNALS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS (MAP_FILE | MAP_PRIVATE)
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#define AUTH_DBM
#define SEM_FLOCK
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define HAVE_ATEXIT
#define HAS_STATFS
#define JAVA_STATIC_LINK
 
#define ZERO(ptr,len) memset(ptr,0,len)
 
#elif defined(SOLARIS)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS

#define HAVE_TIME_R
#define DNS_CACHE
#undef	FILE_UNIX	/* avoid redefinition message */
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
	/* Solaris 2.5 and lower needed the semaphore.
	 * With 2.5.1 they don't need it- a routine is added to daemon.c
	 * which checks the solaris version number and acts appropriately
	 * based on that.
	 */
#undef DAEMON_NEEDS_SEMAPHORE
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_SIGNALS
#define BSD_RLIMIT
#define NEED_CRYPT_H
#define AUTH_DBM
/* The Solaris routines return ENOSPC when too many semaphores are SEM_UNDO. */
#define SEM_FLOCK
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define HAVE_ATEXIT
#define NEED_FILIO
#define HAS_STATVFS

#define ZERO(ptr,len) memset(ptr,0,len)

#elif defined(SUNOS4)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define BSD_SIGNALS
#define BSD_TIME
#define BSD_MAIL
#define BSD_FLOCK
#define BSD_RLIMIT
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef NEED_CRYPT_H
#define NEED_CRYPT_PROTO
#define AUTH_DBM
#define SEM_FLOCK
#define ZERO(ptr,len) memset(ptr,0,len)
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS 1
#undef HAVE_ATEXIT
#define NEED_FILIO
#define HAS_STATFS
#define JAVA_STATIC_LINK

#elif defined(UNIXWARE)
 
#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_RLIMIT
#define NEED_CRYPT_H
#define AUTH_DBM
/* The Solaris routines return ENOSPC when too many semaphores are SEM_UNDO. */
#define SEM_FLOCK
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define NEED_STRCASECMP
#define HAVE_ATEXIT
#define NEED_FILIO
#define HAS_STATVFS
#define CASECMPARG_T const
#define JAVA_STATIC_LINK
#define HAVE_NETCONFIG

#define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)

#define ZERO(ptr,len) memset(ptr,0,len)

#elif defined(NECSVR4) || defined(NCR)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#undef FILE_UNIX
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_RLIMIT
#define NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define NEED_STRCASECMP
#define HAVE_ATEXIT
#define NEED_FILIO
#define HAS_STATVFS
#define JAVA_STATIC_LINK
#define HAVE_NETCONFIG

#define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)

#define ZERO(ptr,len) memset(ptr,0,len)

#elif defined (SONY)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_RLIMIT
#define NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define DLL_CAPABLE
#define NEED_STRCASECMP
#define HAVE_ATEXIT
#define NEED_FILIO
#define JAVA_STATIC_LINK

#define ZERO(ptr,len) memset(ptr,0,len)

#elif defined(SCO)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define DAEMON_UNIX_MOBRULE
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_SIGNALS
#undef BSD_RLIMIT
#undef NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define ZERO(ptr,len) memset(ptr,0,len)
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define HAVE_ATEXIT
#define HAS_STATVFS
#define JAVA_STATIC_LINK

#elif defined(OSF1)

#ifdef HW_THREADS
#define HAVE_TIME_R
#endif
#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#undef BSD_SIGNALS
#define BSD_TIME
#undef BSD_FLOCK
#define BSD_RLIMIT
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#define AUTH_DBM
#define SEM_FLOCK
#define ZERO(ptr,len) memset(ptr,0,len)
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define HAVE_ATEXIT

#elif defined(AIX)
#ifdef HW_THREADS
#define THREAD_ANY
#define HAVE_TIME_R
#undef  NEED_TIME_R
#endif

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#define DAEMON_NEEDS_SEMAPHORE 
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_SIGNALS
#define BSD_RLIMIT
#undef NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define ZERO(ptr,len) memset(ptr,0,len)
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS 1
#define HAVE_ATEXIT
#define HAS_STATFS
#define JAVA_STATIC_LINK

#elif defined(HPUX)

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define NET_SOCKETS
/* warning: mmap doesn't work under 9.04 */
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_FILE | MAP_VARIABLE | MAP_SHARED
#undef BSD_SIGNALS
#undef BSD_RLIMIT
#undef NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define ZERO(ptr,len) memset(ptr,0,len)
#define DLL_CAPABLE
#define DLL_HPSHL
#define HAVE_ATEXIT
#define HAS_STATFS
#define JAVA_STATIC_LINK

#elif defined (IRIX)

#define HAVE_TIME_R
#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_SIGNALS
#define BSD_RLIMIT
#define NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define ZERO(ptr,len) memset(ptr,0,len)
#define HAVE_ATEXIT
#define HAS_STATVFS

#elif defined(SNI)
 
#define FILE_UNIX
#define FILE_INHERIT_FCNTL
#define DAEMON_UNIX_MOBRULE
#ifdef MCC_PROXY
#define DAEMON_NEEDS_SEMAPHORE
#endif
#define NET_SOCKETS
#define FILE_UNIX_MMAP
#define FILE_MMAP_FLAGS MAP_PRIVATE
#define SHMEM_UNIX_MMAP
#define SHMEM_MMAP_FLAGS MAP_SHARED
#undef BSD_RLIMIT
#define NEED_CRYPT_H
#define AUTH_DBM
#define SEM_FLOCK
#define DLL_CAPABLE
#define DLL_DLOPEN
#define DLL_DLOPEN_FLAGS RTLD_NOW
#define NEED_STRCASECMP
#define HAVE_ATEXIT
/* ??? */
#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE

#define USE_PIPE
#define NEED_FILIO
#define HAS_STATVFS
#define JAVA_STATIC_LINK
#define HAVE_NETCONFIG

#define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
 
#define ZERO(ptr,len) memset(ptr,0,len)

#elif defined (XP_WIN32)      /* Windows NT */

#include <wtypes.h>
#include <winbase.h>

typedef void* PASSWD;

#define ACCELERATOR_CACHE
#define MALLOC_POOLS
#define DNS_CACHE
#define LOG_BUFFERING
#define FILE_WIN32
#define FILE_WIN32_MMAP
#define SHMEM_WIN32_MMAP
#define NET_SOCKETS
#define NET_WINSOCK
#define DAEMON_ANY
#define DAEMON_WIN32
#define AUTH_DBM
#define ZERO(ptr, len) ZeroMemory(ptr, len)
#define caddr_t PCHAR
#define SEM_WIN32
#define DLL_CAPABLE
#define DLL_WIN32
#define THREAD_ANY
#define USE_NSPR
#define THREAD_NSPR_KERNEL
#define NEED_CRYPT_PROTO
#define NO_DOMAINNAME
#define NEEDS_WRITEV

/* The stat call under NT doesn't define these macros */
#ifndef S_ISDIR
#define S_ISDIR(mode)   ((mode&S_IFMT) == S_IFDIR)
#endif
#ifndef S_ISREG
#define S_ISREG(mode)   ((mode&S_IFMT) == S_IFREG)                             
#endif
#ifndef S_ISLNK
#define S_ISLNK(x) (0)
#endif

#define NEED_STRCASECMP
#endif	/* Windows NT */


#if defined(FILE_UNIX_MMAP) || defined(FILE_WIN32_MMAP)
#define FILE_MMAP
#endif

#ifdef NEED_STRCASECMP
#ifndef CASECMPARG_T
#define CASECMPARG_T
#endif
#define strcasecmp util_strcasecmp
#define strncasecmp util_strncasecmp
NSAPI_PUBLIC int util_strcasecmp(CASECMPARG_T char *s1, CASECMPARG_T char *s2);
NSAPI_PUBLIC int util_strncasecmp(CASECMPARG_T char *s1, CASECMPARG_T char *s2, int n);
#endif

/* NS_MAIL builds sec-key.c which calls systhread_init, which requires */
/* that USE_NSPR is defined when systhr.c is compiled.  --lachman */
/* MCC_PROXY does the same thing now --nbreslow -- LIKE HELL --ari */
#if (defined(MCC_BATMAN) || defined(MCC_HTTPD) || defined(MCC_ADMSERV) || defined(NS_MAIL)) && defined(XP_UNIX)
#define USE_NSPR
/* XXXrobm This is UNIX-only for the moment */
#define LOG_BUFFERING
#ifdef SW_THREADS
#define THREAD_NSPR_USER
#else
#define THREAD_NSPR_KERNEL
#ifdef IRIX
#undef SEM_FLOCK
#define SEM_IRIX
#endif 
#endif
#define THREAD_ANY
#endif

#if defined(SNI)
#define socketpair(a,b,c,d) pipe(d)
#endif

#endif
