/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * daemon.h: Things related to the accepting connections
 * 
 * Rob McCool
 */


#ifndef DAEMON_H
#define DAEMON_H

#include "net.h"
#include "session.h"

#ifdef XP_UNIX
#include <pwd.h>    /* struct passwd */
#endif /* XP_UNIX */


/* ------------------------------- Defines -------------------------------- */


NSAPI_PUBLIC void child_exit(int status);


/* Codes for child_status */
#define CHILD_EMPTY_SLOT 0xfe
#define CHILD_AWAIT_CONNECT 0xff
#define CHILD_PROCESSING 0x00
#define CHILD_READING 0x01
#define CHILD_WRITING 0x02
#define CHILD_RESOLVING 0x03
#define CHILD_KEEPALIVE_LISTEN 0x04
#define CHILD_KEEPALIVE_ACCEPT 0x05
#ifdef XP_WIN32
/* Need completors to handle async IO */
#define CHILD_DONE_PROCESSING 0x14
#define CHILD_DONE_READING 0x15
#define CHILD_DONE_WRITING 0x16
#define CHILD_DONE_RESOLVING 0x17
#endif

#ifdef XP_WIN32 
#define MAX_IP_DOMAINS 256
struct _multiple_domains {
	char *address;
	char *docroot;
	SYS_NETFD sd;
	int threads;
	int AddressNumber;
};
typedef struct _multiple_domains multiple_domains;

/* array of address-docroot mappings */
extern multiple_domains domain_array[];

#endif /* XP_WIN32 */


/* #ifdef DAEMON_STATS */

#define DSTATS_MAJOR_VERSION		(char)0x1
#define DSTATS_MINOR_VERSION		(char)0x0

#define DSTATS_SOFTWARE_ENTERPRICE	(char)0x1
#define DSTATS_SOFTWARE_PERSONAL	(char)0x2
#define DSTATS_SOFTWARE_PROXY		(char)0x3
#define DSTATS_SOFTWARE_NEWS		(char)0x4

#define DSTATS_FILE			"daemonstat."

typedef struct _StatHeader {
    int  header_size;		/* sizeof StatHeader */
    int  slot_size;		/* sizeof StatSlot */
    char software;
    char version_major;
    char version_minor;
    char active;
    char pad1[2 * sizeof(long) - 4 * sizeof(char)];
    int  restart_cookie;	/* changing restart counter */
    int  maxprocs;		/* current MaxProcs */
    int  maxthreads;		/* current MaxThreads */
    char pad2[2 * sizeof(long) - sizeof(int)];
    long start_time;
} StatHeader;

typedef struct _StatSlot {
    char mode;
    char pad[sizeof(long) - sizeof(char)];

    long tot_bytes;
    long tot_reqs;
    long tot_errs;

    long tot_2xx;
    long tot_3xx;
    long tot_4xx;
    long tot_5xx;
    long tot_xxx;

    long tot_200;
    long tot_302;
    long tot_304;
    long tot_401;
    long tot_403;
#ifdef XP_WIN32
    long state_counts[CHILD_RESOLVING+1];	/* for threads handling many reqs */
    long cur_async_io;		/* current async IO requests */
    long tot_async_io;		/* total async IO requests */
#endif
} StatSlot;
/* #endif */


#ifdef DAEMON_STATS

void child_status2(int http_status, long bytes);

#endif /* DAEMON_STATS */


typedef struct {
    char *ipstr;
    int port;
#if defined (XP_UNIX)
    struct passwd *pw;
    char *chr;
    char *pidfn;
#elif defined (XP_WIN32)
    void(*child_callback)(Session *);
    void(*rotate_callback)();
    char *servid;
    multiple_domains *domains;
#endif /* XP_WIN32 */
    void (*rcback)(int);
#if defined(DAEMON_UNIX_MOBRULE) || defined(DAEMON_WIN32)
    int maxprocs, minprocs, proclife;
#endif
#if defined (THREAD_ANY) || defined (THREAD_WIN32)
    int maxthreads, minthreads;
#endif
#ifdef NET_SSL
    char *secure_keyfn;
    char *secure_certfn;
    int secure_auth;
    int secure_session_timeout;
    long ssl3_secure_session_timeout;
    int security;
    int ssl3;
    int ssl2;
#endif
    int single_accept;
    int num_keep_alives;
    int mp_optimization;
    int concurrency;
} daemon_s;

#define SINGLE_ACCEPT_NONE		-1		/* uninitialized state */
#define SINGLE_ACCEPT_OFF		0
#define SINGLE_ACCEPT_ON		1
#define SINGLE_ACCEPT_PARTIAL	2		/* do mutex but not file lock */

/* ------------------------------ Prototypes ------------------------------ */

#ifdef MCC_PROXY
/* A unique serial number assigned to each child. */
extern int child_serial;
#endif

/*
 * daemon_run accepts whether or not it should detach from its parent process,
 * and a daemon structure as its arguments. The daemon structure contains 
 * a port number, a root directory to chroot to (can be NULL), a filename to 
 * log the daemon pid to (can be NULL). daemon_run never returns.
 * 
 * child_callback is a function which will be called every time a new
 * connection is recieved. Session is a new session ID.
 *
 * rcback is a function which is a restart function: When SIGHUP is received,
 * this function will be called. You may give SIG_DFL if you don't want to
 * support restarting. The rcback will be passed SIGHUP.
 *
 * pw is the passwd entry to run the daemon as. If the effective user id is
 * root, daemon_run will try to set its uid and gid to the user pointed
 * to by this structure. You may pass NULL.
 */

#ifdef XP_UNIX
NSAPI_PUBLIC
void daemon_run(int det, void (*child_callback)(Session *), daemon_s *d);
#else /* XP_WIN32 */
#if defined (USE_NSPR) && !defined (NO_NSPR_THREADS)
NSAPI_PUBLIC void _ntdaemon_run(void *);
#else /* !USE_NSPR || NO_NSPR_THREADS */
NSAPI_PUBLIC unsigned  int __stdcall _ntdaemon_run(void *);
#endif /* !USE_NSPR || NO_NSPR_THREADS */
#endif /* XP_WIN32 */


/*
 * daemon_atrestart registers a function to be called fn, with the given
 * void pointer as an argument, when the server is restarted.
 */

NSAPI_PUBLIC void daemon_atrestart(void (*fn)(void *), void *data);



/*
 * fork is a wrapper for the system's fork function. This closes the listen
 * socket for the mob. This also makes sure that a threaded daemon only gets
 * the calling thread and not all of them.
 */

NSAPI_PUBLIC pid_t child_fork(void);


/*
 * Set status to the given code for statistics reporting
 */

#ifdef DAEMON_STATS
NSAPI_PUBLIC void child_status(int code);
#else /* ! DAEMON_STATS */
#define child_status(code) (void)(code)
#endif /* DAEMON_STATS */

/* servssl_init is in base/servssl.c */
#ifdef NET_SSL
NSAPI_PUBLIC 
void servssl_init(char *keyfn, char *certfn, int stimeout, long ssl3timeout,
		  char *servid);

#endif /* NET_SSL */

#endif
