/*	$NetBSD: rk_v1crypto.h,v 1.1 2020/05/17 19:57:25 riastradh Exp $	*/

/*-
 * Copyright (c) 2020 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Taylor R. Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	_ARM_ROCKCHIP_RK_V1CRYPTO_H
#define	_ARM_ROCKCHIP_RK_V1CRYPTO_H

#define	RK_V1CRYPTO_INTSTS	0x0000 /* Interrupt Status */
#define	RK_V1CRYPTO_INTSTS_PKA_DONE	__BIT(5)
#define	RK_V1CRYPTO_INTSTS_HASH_DONE	__BIT(4)
#define	RK_V1CRYPTO_INTSTS_HRDMA_ERR	__BIT(3)
#define	RK_V1CRYPTO_INTSTS_HRDMA_DONE	__BIT(2)
#define	RK_V1CRYPTO_INTSTS_BCDMA_ERR	__BIT(1)
#define	RK_V1CRYPTO_INTSTS_BCDMA_DONE	__BIT(0)

#define	RK_V1CRYPTO_INTENA	0x0004 /* Interrupt Enable */
#define	RK_V1CRYPTO_INTENA_PKA_DONE	__BIT(5)
#define	RK_V1CRYPTO_INTENA_HASH_DONE	__BIT(4)
#define	RK_V1CRYPTO_INTENA_HRDMA_ERR	__BIT(3)
#define	RK_V1CRYPTO_INTENA_HRDMA_DONE	__BIT(2)
#define	RK_V1CRYPTO_INTENA_BCDMA_ERR	__BIT(1)
#define	RK_V1CRYPTO_INTENA_BCDMA_DONE	__BIT(0)

#define	RK_V1CRYPTO_CTRL	0x0008 /* Control */
#define	RK_V1CRYPTO_CTRL_MASK		__BITS(31,16)
#define	RK_V1CRYPTO_CTRL_TRNG_FLUSH	__BIT(9)
#define	RK_V1CRYPTO_CTRL_TRNG_START	__BIT(8)
#define	RK_V1CRYPTO_CTRL_PKA_FLUSH	__BIT(7)
#define	RK_V1CRYPTO_CTRL_HASH_FLUSH	__BIT(6)
#define	RK_V1CRYPTO_CTRL_BLOCK_FLUSH	__BIT(5)
#define	RK_V1CRYPTO_CTRL_PKA_START	__BIT(4)
#define	RK_V1CRYPTO_CTRL_HASH_START	__BIT(3)
#define	RK_V1CRYPTO_CTRL_BLOCK_START	__BIT(2)
#define	RK_V1CRYPTO_CTRL_TDES_START	__BIT(1)
#define	RK_V1CRYPTO_CTRL_AES_START	__BIT(0)

#define	RK_V1CRYPTO_CONF	0x000c /* ? */
#define	RK_V1CRYPTO_CONF_HR_ADDR_MODE	__BIT(8)
#define	RK_V1CRYPTO_CONF_BT_ADDR_MODE	__BIT(7)
#define	RK_V1CRYPTO_CONF_BR_ADDR_MODE	__BIT(6)
#define	RK_V1CRYPTO_CONF_MODE_FIX		1
#define	RK_V1CRYPTO_CONF_MODE_INCR		0
#define	RK_V1CRYPTO_CONF_BYTESWAP_HRFIFO __BIT(5)
#define	RK_V1CRYPTO_CONF_BYTESWAP_BTFIFO __BIT(4)
#define	RK_V1CRYPTO_CONF_BYTESWAP_BRFIFO __BIT(3)
#define	RK_V1CRYPTO_CONF_DESSEL		__BIT(2)
#define	RK_V1CRYPTO_CONF_DESSEL_AES		0
#define	RK_V1CRYPTO_CONF_DESSEL_DES		1 /* 3DES? */
#define	RK_V1CRYPTO_CONF_HASHINSEL	__BITS(1,0)
#define	RK_V1CRYPTO_CONF_HASHINSEL_INDEP	0
#define	RK_V1CRYPTO_CONF_HASHINSEL_BLKIN	1
#define	RK_V1CRYPTO_CONF_HASHINSEL_BLKOUT	2

#define	RK_V1CRYPTO_BRDMAS	0x0010 /* Block Rx DMA Start */
#define	RK_V1CRYPTO_BTDMAS	0x0014 /* Block Tx DMA Start */
#define	RK_V1CRYPTO_BRDMAL	0x0018 /* Block Rx DMA Length */
#define	RK_V1CRYPTO_BTDMAL	0x0020 /* Block Tx DMA Length */
#define	RK_V1CRYPTO_HRDMAS	0x001c /* Hash Rx DMA Start */
#define	RK_V1CRYPTO_HRDMAL	0x0020 /* Hash Rx DMA Length */

#define	RK_V1CRYPTO_AES_CTRL	0x0080 /* AES Control */
#define	RK_V1CRYPTO_AES_CTRL_BYTESWAP_CNT __BIT(11)
#define	RK_V1CRYPTO_AES_CTRL_BYTESWAP_KEY __BIT(10)
#define	RK_V1CRYPTO_AES_CTRL_BYTESWAP_IV __BIT(9)
#define	RK_V1CRYPTO_AES_CTRL_BYTESWAP_DO __BIT(8)
#define	RK_V1CRYPTO_AES_CTRL_BYTESWAP_DI __BIT(7)
#define	RK_V1CRYPTO_AES_CTRL_KEYCHANGE	__BIT(6)
#define	RK_V1CRYPTO_AES_CTRL_MODE	__BITS(5,4)
#define	RK_V1CRYPTO_AES_CTRL_MODE_ECB		0
#define	RK_V1CRYPTO_AES_CTRL_MODE_CBC		1
#define	RK_V1CRYPTO_AES_CTRL_MODE_CTR		2
#define	RK_V1CRYPTO_AES_CTRL_KEYSIZE	__BITS(3,2)
#define	RK_V1CRYPTO_AES_CTRL_KEYSIZE_128	0
#define	RK_V1CRYPTO_AES_CTRL_KEYSIZE_192	1
#define	RK_V1CRYPTO_AES_CTRL_KEYSIZE_256	2
#define	RK_V1CRYPTO_AES_CTRL_FIFOMODE	__BIT(1)
#define	RK_V1CRYPTO_AES_CTRL_DIR	__BIT(0)
#define	RK_V1CRYPTO_AES_CTRL_DIR_ENC		0
#define	RK_V1CRYPTO_AES_CTRL_DIR_DEC		1

#define	RK_V1CRYPTO_AES_STS	0x0084 /* AES Status */
#define	RK_V1CRYPTO_AES_STS_DONE	__BIT(0)

#define	RK_V1CRYPTO_AES_DIN(n)  (0x0088 + 4*(n)) /* AES Input */
#define	RK_V1CRYPTO_AES_DOUT(n) (0x0098 + 4*(n)) /* AES Output */
#define	RK_V1CRYPTO_AES_IV(n)   (0x00a8 + 4*(n)) /* AES IV */
#define	RK_V1CRYPTO_AES_KEY(n)  (0x00b8 + 4*(n)) /* AES Key */
#define	RK_V1CRYPTO_AES_CNT(n)  (0x00d8 + 4*(n)) /* AES Input Counter */

#define	RK_V1CRYPTO_TDES_CTRL	0x0100 /* 3DES Control */
#define	RK_V1CRYPTO_TDES_CTRL_BYTESWAP_KEY __BIT(8)
#define	RK_V1CRYPTO_TDES_CTRL_BYTESWAP_IV __BIT(7)
#define	RK_V1CRYPTO_TDES_CTRL_BYTESWAP_DO __BIT(6)
#define	RK_V1CRYPTO_TDES_CTRL_BYTESWAP_DI __BIT(5)
#define	RK_V1CRYPTO_TDES_CTRL_MODE	__BIT(4)
#define	RK_V1CRYPTO_TDES_CTRL_MODE_ECB		0
#define	RK_V1CRYPTO_TDES_CTRL_MODE_CBC		1
#define	RK_V1CRYPTO_TDES_CTRL_KEYMODE	__BIT(3)
#define	RK_V1CRYPTO_TDES_CTRL_KEYMODE_EDE	0
#define	RK_V1CRYPTO_TDES_CTRL_KEYMODE_EEE	1
#define	RK_V1CRYPTO_TDES_CTRL_SELECT	__BIT(2)
#define	RK_V1CRYPTO_TDES_CTRL_SELECT_DES	0
#define	RK_V1CRYPTO_TDES_CTRL_SELECT_TDES	1
#define	RK_V1CRYPTO_TDES_CTRL_FIFOMODE	__BIT(1)
#define	RK_V1CRYPTO_TDES_CTRL_DIR	__BIT(0)
#define	RK_V1CRYPTO_TDES_CTRL_DIR_ENC		0
#define	RK_V1CRYPTO_TDES_CTRL_DIR_DEC		1

#define	RK_V1CRYPTO_TDES_STS	0x0104 /* 3DES Status */
#define	RK_V1CRYPTO_TDES_STS_DONE	__BIT(0)

#define	RK_V1CRYPTO_TDES_DIN(n) (0x0108 + 4*(n)) /* 3DES Input */
#define	RK_V1CRYPTO_TDES_DOUT(n)(0x0110 + 4*(n)) /* 3DES Output */
#define	RK_V1CRYPTO_TDES_IV(n)  (0x0118 + 4*(n)) /* 3DES IV */
#define	RK_V1CRYPTO_TDES_KEY(n) (0x0120 + 4*(n)) /* 3DES Key(1,2,3) */

#define	RK_V1CRYPTO_HASH_CTRL	0x0180 /* Hash Control */
#define	RK_V1CRYPTO_HASH_SWAP_DO	__BIT(3)
#define	RK_V1CRYPTO_HASH_SWAP_DI	__BIT(2)
#define	RK_V1CRYPTO_HASH_SELECT		__BITS(1,0)
#define	RK_V1CRYPTO_HASH_SELECT_SHA1		0
#define	RK_V1CRYPTO_HASH_SELECT_MD5		1
#define	RK_V1CRYPTO_HASH_SELECT_SHA256		2
#define	RK_V1CRYPTO_HASH_SELECT_PRNG		3 /* ??? */

#define	RK_V1CRYPTO_HASH_STS	0x0184 /* Hash Status */
#define	RK_V1CRYPTO_HASH_STS_DONE	__BIT(0)

#define	RK_V1CRYPTO_HASH_MSG_LEN	0x0188 /* Hash Message Len */
#define	RK_V1CRYPTO_HASH_DOUT(n)(0x018c + 4*(n)) /* Hash Result */
#define	RK_V1CRYPTO_HASH_SEED(n)(0x01ac + 4*(n)) /* HMAC/PRNG key */

#define	RK_V1CRYPTO_TRNG_CTRL	0x0200 /* TRNG Control */
#define	RK_V1CRYPTO_TRNG_CTRL_OSC_ENABLE __BIT(16)
#define	RK_V1CRYPTO_TRNG_CTRL_CYCLES	__BITS(15,0)

#define	RK_V1CRYPTO_TRNG_DOUT(n)(0x0204 + 4*(n)) /* TRNG Output */
#define	RK_V1CRYPTO_TRNG_NOUT		8	/* up to 8 32-bit */

#define	RK_V1CRYPTO_PKA_CTRL	0x0280 /* PKA Control (RSA?) */
#define	RK_V1CRYPTO_PKA_CTRL_SIZE	__BITS(1,0)
#define	RK_V1CRYPTO_PKA_CTRL_SIZE_512		0
#define	RK_V1CRYPTO_PKA_CTRL_SIZE_1024		1
#define	RK_V1CRYPTO_PKA_CTRL_SIZE_2048		2

#define	RK_V1CRYPTO_M		0x0400 /* RSA `message' */
#define	RK_V1CRYPTO_C		0x0500 /* 2^(2 ceil(lg n) + 2) mod n */
#define	RK_V1CRYPTO_N		0x0600 /* RSA modulus? */
#define	RK_V1CRYPTO_E		0x0700 /* RSA exponent? */

#endif	/* _ARM_ROCKCHIP_RK_V1CRYPTO_H */
