/* @(#) du.h 1.15 93/08/18 00:09:02 
 *
 * "du" enhanced disk usage summary - version 2.
 *
 * Copyright 1990-1993, Unicom Systems Development.  All rights reserved.
 * See accompanying README file for terms of distribution and use.
 *
 * Edit at tabstops=4.
 */


#define TRUE		1
#define FALSE		0

/*
 * Severity levels for errmssg() routine.
 */
#define ERR_WARN	0
#define ERR_ABORT	1

#ifdef DEBUG
# define Dprintf	if (!Debug) ; else fprintf
#endif

#ifdef S_IFMT
# ifndef S_ISREG
#  define S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)
# endif
# ifndef S_ISDIR
#  define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
# endif
#endif

#if defined(lint) && defined(NULL)
# undef NULL
# define NULL 0
#endif

/*
 * A boolean true/false value.
 */
typedef int BOOL;

/*
 * Structure used to store information on mounted filesystems.
 */
struct fsinfo {
	int dev;				/* the device number						*/
	int nino;				/* number of available inodes on filesys	*/
	int bsize;				/* num bytes in a disk block for this dev	*/
	int nindir;				/* num direct disk addr can fit in a block	*/
	BOOL remote;			/* is this filesys a remote mount?			*/
#ifdef BROKE_STBLOCKS
	int stbsize;			/* quanta for st_blocks reported by stat(2)	*/
#endif
	int path_max;			/* max pathlen for an entry on this filesys	*/
	unsigned char *idone;	/* bit vector to mark inodes of links done	*/
};


/*
 * Structure to accumulate usage statistics.
 *
 * The statistics are accumulated in a chronological breakdown, as
 * specified by "Num_break" and the "Breakdown[]" array.  "Num_break"
 * indicates the number of columns in the breakdown, and "Breakdown[]"
 * specifies the age for each of those columns.
 *
 * The "Num_break" value will range from 1 to MAX_BREAK.  The "blocks[n]"
 * value accumulates the disk usage of all filesystem entries "Breakdown[n]"
 * days or older.  The "files[n]" value counts the number of filesystem
 * entries that contributed to that total.
 *
 * By default, "Num_break" will be 1 and "Breakdown[0]" will be 0.  That
 * says accumulate a single set of statistics for all filesystem entries
 * zero days old or older (i.e. everything).
 *
 */
struct dusage {
	long blocks[MAX_BREAK];	/* accumulated disk usage					*/
	int files[MAX_BREAK];	/* number of disk entries					*/
};


#ifdef INTERN
#	define EXTERN
#	define INIT(X) = X
#else
#	define EXTERN extern
#	define INIT(X)
#endif

EXTERN char *Progname;
#ifdef DEBUG
EXTERN BOOL Debug INIT(FALSE);
#endif

/*
 * What to do at filesystem mount points.
 */
EXTERN enum {
	FS_ALWAYS_CROSS,	/* always cross mount points (default)	*/
	FS_NEVER_CROSS,		/* never cross mount points (-f)		*/
	FS_LOCAL_ONLY		/* cross only local mount points (-F)	*/
} Handle_filesys INIT(FS_ALWAYS_CROSS);

/*
 * What to do with hard links.
 */
EXTERN enum {
	LK_COUNT_FIRST,		/* count just first link encountered (default)	*/
	LK_COUNT_ALL,		/* handle all hard links (-l)					*/
	LK_COUNT_NONE,		/* ignore all hard links (-u)					*/
	LK_COUNT_AVERAGE	/* average disk usage across hard links (-L)	*/
} Handle_links INIT(LK_COUNT_FIRST);

/*
 * What to report.
 */
EXTERN enum {
	PR_DIRS_ONLY,		/* report usage at all directories (default)	*/
	PR_TOTALS_ONLY,		/* report usage just for cmd line items (-s)	*/
	PR_EVERYTHING		/* report usage for everything encountered (-a)	*/
} Handle_output INIT(PR_DIRS_ONLY);

/*
 * If true, accumulate the disk usage of a subdirectory into the usage
 * of its parent directory.  If false, the disk usage of a directory will
 * include just the contents of that directory.
 */
EXTERN BOOL Do_accum_subdirs INIT(TRUE);

/*
 * If true, display file counts as well as disk block usage.
 */
EXTERN BOOL Do_file_counts INIT(FALSE);

#ifdef OBSOLETEOPT
/*
 * If true, descend into directories and accumulate usage (subject to
 * filesystem handling at mount points).  If false, do not descend into
 * directories and simply report the usage of the directory filesystem
 * entry (i.e. sans contents) as its usage.
 *
 * This is a pretty useless option, but was present in the original
 * "enh-du".  Unless somebody tells me they really use it, it is
 * subject to removal in a future version.
 */
EXTERN BOOL Do_descend_dirs INIT(TRUE);
#endif

/*
 * If true, the sum of the usages of all items specified on the command
 * line is displayed.  If false, this grand total is omitted.
 */
EXTERN BOOL Do_print_grand_total INIT(FALSE);

/*
 * If true, error messages are displayed (rational behavior).
 * If false, error messages are suppressed (traditional behavior).
 */
#ifdef PRINT_ERRORS
EXTERN BOOL Do_print_errors INIT(TRUE);
#else
EXTERN BOOL Do_print_errors INIT(FALSE);
#endif

/*
 * Block size used in reporting disk usage.  The actual disk usage is
 * calculated, and then scaled to blocks of the size indicated here.  If
 * the value is zero, then the native filesystem block size is used.
 */
EXTERN int Report_blksize INIT(REPORT_BLKSIZE);

/*
 * Only count usage for the user whose UID is this value, or
 * negative to count usage for all users.
 */
EXTERN int Selected_user INIT(-1);

/*
 * Specifies ages for the chronological breakdown in a (struct dusage).
 * See comments in the (struct dusage) declaration for more info.
 */
EXTERN int Breakdown[MAX_BREAK] INIT({0});

/*
 * Number of columns in the chronological breakdown.
 * Specifies number of elements in "Breakdown[]" that are actually used.
 */
EXTERN int Num_break INIT(1);

/*
 * Current time, used for calculation of the chronological breakdown.
 */
EXTERN long Curr_time;


#if defined(__STDC__) && !defined(NO_PROTOTYPE)
#	define __ARGS(X) X
#else
#	define __ARGS(X) ()
#endif

/*
 * Procedures.
 */
PTRTYPE *xmalloc __ARGS((unsigned));
PTRTYPE *xrealloc __ARGS((PTRTYPE *, unsigned));
void errmssg __ARGS((int, int, char *, ...));
void zero_usage __ARGS((struct dusage *));
void set_usage __ARGS((struct dusage *, time_t, long));
void add_usage __ARGS((struct dusage *, struct dusage *));
void print_usage __ARGS((char *, struct dusage *));
int max_path_len __ARGS((char *));
void du_entry __ARGS((char *, struct dusage *));
int du_dir __ARGS((char *, struct stat	*, struct fsinfo *, struct dusage *));
void fs_initinfo __ARGS((void));
struct fsinfo *fs_getinfo __ARGS((struct stat *));
int fs_linkdone __ARGS((struct fsinfo *, struct stat *));
long fs_numblocks __ARGS((struct fsinfo *, struct stat *));


extern int errno;

