#!/usr/local/bin/perl
# artrate.pl 1.4 1995/09/29 18:33:12 davidsen Exp

require "Log_to_date.pl";
require "Fract_hr.pl";

while (<>) {
  ($mon, $day, $timestr, $text) = split(/[ \t]+/, $_, 4);
  $time = &Fract_hr100($timestr);
  #
  # Look for date rollover
  if ($day ne $OLDday || $mon ne $OLDmon) {
    # if valid time or count, save data point
    if ($oldtime || $count) {
      printf XYFILE "%.3f %.3f\n", $oldtime/100.0, $count/36.0;
    }
    # if the file has been defined, close it
    close(XYFILE) if $xyfile ne "";

    # convert the date to YYMMDD format, use in plot filename
    $DS = &Log_to_date($mon,$day+0);
    $xyfile = "artrate_xy.$DS";
    # open the file and generate a progress report
    open(XYFILE, ">$xyfile") || die "Can't create $xyfile";
    print "Start date $DS\n";

    # reset counts and values used as flags
    $OLDmon = $mon; $OLDday = $day;
    $oldtime = 0;
    $count = 0;
  }
  #
  # See if still same time, bump count of so
  if ($time eq $oldtime) { ++$count; }
  else {
    # new slice, output point of time or count non-zero
    if ($oldtime || $count) {
      printf XYFILE "%.3f %.3f\n", $oldtime/100.0, $count/36.0;

      # output zero points for any missing time slices
      $lapse = $time - $oldtime - 1;
      $lapse += 2400 if $lapse < 0;
      $current = $oldtime + $lapse;
      while (++$oldtime < $current) {
        printf XYFILE "%.3f 0\n", $oldtime/100.0;
      }
    }
    
    # reset count and values used for flags
    $oldtime = $time;
    $count = 1;
  }
}

# EOF processing, output last point if any
if ($count) {
  printf XYFILE "%.3f %.3f\n", $oldtime/100.0, $count/36.0;
}
