/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the shell user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


/* $Log: wais-ui.h,v $
 * Revision 1.1.1.1  1996/06/04 20:37:57  julia
 * autoconf baseline
 *
 * Revision 1.1.1.1  1996/04/30 18:22:41  dmitriy
 * Version 2.1 -- autoconf baseline
 *
 * Revision 1.1.1.2  1996/04/23  19:46:31  dmitriy
 * autoconf baseline
 *
 * Revision 2.0.1.1  1995/09/15 09:55:38  pfeifer
 * patch7: Fixed CNIDR copyright line.
 *
 * Revision 2.0  1995/09/08  08:05:37  pfeifer
 * Metaconfig baseline
 *
 * Revision 1.2  1994/08/05  07:19:48  pfeifer
 * Release beta 04
 *
 * Revision 1.1  93/06/23  20:02:41  warnock
 * Initial revision
 * 
 * Revision 1.1  1993/02/16  15:09:27  freewais
 * Initial revision
 *
 * Revision 1.4  92/03/17  14:33:37  jonathan
 * Cleaned up, prototyped.
 * 
 */

#ifndef _H_WAIS_UI
#define _H_WAIS_UI

#include "ui.h"

#ifndef MAX_MESSAGE_LEN
#define MAX_MESSAGE_LEN BUFSZ
#endif

#define QUESTION_FILE_VERSION 1

#define CHARS_PER_PAGE 2000

/* function definitions */

void showDiags (diagnosticRecord** d);
void printDiags (diagnosticRecord** d);
void write_text_record_completely (FILE* fp, 
				   WAISDocumentText *record,
				   Boolean quote_string_quotes);
DocList build_response_list (SearchResponseAPDU* response,
			     SourceID source, char** seed_words_used);
void replacecontrolM (char* buffer,long* length);
void SearchWais (Question q);
char* GetWaisDocument (Question q, DocumentID doc,
		       char* type, FILE* fp, long* written);
void RetrieveWaisDocument (void (*start_output)(), void (*end_output)(),
			   Question q, DocumentID doc);

void dumptext (FILE* fp, char* buffer, long size);
void test_connection (Question q);
void close_source (Source source);
DocumentID getNextorPrevDoc (Question q, Source source,
			     DocumentID doc, Boolean nextp);

#endif
