/*--------------------------------------------------------------------------
 * ABSTRACT:    wutil.h -- WAIS TOOLS header file
 *
 * AUTHOR
 *   M. Tracy Shen
 *
 *
 *------------------------------------------------------------------------*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */

#ifndef _H_WAIS_util_
#define _H_WAIS_util_

#include "cdialect.h"

#include "cutil.h"

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

void twais_format_req_apdu ( boolean use_template, char* apdu_buff, long* len);
void twais_dsply_rsp_apdu ( char* rsp_buff, long rsp_len);
void twais_free_apdu (char* apdu_buff);

long twais_format_init_apdu ( boolean use_template, char* apdu_buff);
long twais_format_typ3_srch_apdu ( boolean use_template, char* apdu_buff);
long twais_format_typ1_srch_apdu ( boolean use_template, char* apdu_buff);

void twais_dsply_init_rsp_apdu ( char* buffer);
void twais_dsply_init_apdu ( char* buffer);
void twais_dsply_srch_rsp_apdu ( char* buffer);
void twais_dsply_srch_apdu ( char* buffer);

void twais_tmplt_init_apdu (char* buff, long* buff_len);
void twais_tmplt_init_rsp_apdu (char* buff, long* buff_len);
void twais_tmplt_typ1_srch_apdu ( char* buff, long* buff_len);
void twais_tmplt_typ3_srch_rsp_apdu ( char* buff, long* buff_len);

#endif

#ifdef __cplusplus
	}
#endif /* def __cplusplus */
