/*
 * pcmcia.c for Megaherz modem and D-Link DE-650 cards
 *
 * The following code is based on the original pcmcia.c from Bdale Garbee
 * as well as the Linux dl650.c code (an example for setting up D-Link).
 * Cleaned up the code a bit and added the D-Link functionality.
 *
 * November 1994	Ray Davis (rdavis@convex.com)
/*

/*-
 * Copyright (c) 1993 Garbee and Garbee.  All rights reserved.
 *   written by Bdale Garbee, N3EUA, bdale@gag.com.
 *
 *	$Id: pcmcia.c,v 1.1 1994/01/30 00:44:06 bdale Exp $
 */

/*
 * The slot for each card is currently hardwired.
 * Change these as needed...
 * PCMCIA Slot A = 0	PCMCIA Slot B = 1
 */
#define SLOT_DLINK	0
#define SLOT_MEGAHERTZ	1

/*
 * Pseudo-Device-Driver for Intel 82365SL PCMCIA Interface Controller
 *
 * TODO:
 *	make code use values in config file, not hard-coded addresses!
 *	separate PCIC code from Megahertz Modem Code
 *	don't assume, identify!
 *	add support for both slots on the controller
 *	add support for other types of cards
 *	
 */

#include "pcmcia.h"

#if NPCMCIA > 0

#include "param.h"
#include "kernel.h"
#include "systm.h"
#include "buf.h"
#include "device.h"
#include "malloc.h"

#include "vm/vm.h"

#include "isa.h"
#include "isavar.h"
#include "icu.h"

#include "machine/cpu.h"

#include "ic/i82365sl.h"

#define ETHER_ADDR_LEN  6	/* taken from netinet/if_ether.h */

/* hackola - used in the hacks below */
typedef unsigned char byte;
typedef unsigned short word;
byte reg0_val;
unsigned uSysMemPage = 0xD000;          /* Default page D000 */

/*
 * The ethernet driver (ne or ed) will have a problem reading the
 * D-Link cards ethernet address in the normal NE-2000 place.  The
 * hack here is to store the true address in a global variable and
 * if the global variable dlink_ioaddr is equal to the current in
 * the driver then use the global address instead of trying to read
 * it from the card.  I'm sure there is a better way to do this,
 * but I just want to get it working.
 */
u_char dlink_eth_addr[ETHER_ADDR_LEN] = { 0,0,0,0,0,0 };
int dlink_ioaddr = 0;

int mciaprobe __P((struct device *parent, struct cfdata *cf, void *aux));

/* lose these eventually... */
void pcic_mhz_hack();
void pcic_dlink_hack();

/*
 * PCIC support routines: PCIC_Read() PCIC_In() PCIC_Out() PCIC_Out16()
 */

byte
PCIC_Read(word base, word reg)
{
    outb(base, reg);
    return inb(base+1);
}

#define PCIC_In(A) _PCIC_In(slot_offset+A)
unsigned
_PCIC_In(int address)
{
    outb(PCIC_INDEX, address);
    return inb(PCIC_DATA);
}

#define PCIC_Out(A,D) _PCIC_Out(slot_offset+A,D)
void
_PCIC_Out(int address, int data)
{
    outb(PCIC_INDEX, address);
    outb(PCIC_DATA, data);
}

#define PCIC_Out16(A,D) (PCIC_Out(A,((D)&0xff)), PCIC_Out((A+1),((D)>>8)))




struct cfdriver pcmciacd =
        { NULL, "mcia", mciaprobe, 0, 0 };

/* ARGSUSED */
mciaprobe(parent, cf, aux)
	struct device *parent;
	struct cfdata *cf;
	void *aux;
{
	register struct isa_attach_args *ia = (struct isa_attach_args *) aux;
	word ioaddr;
	caddr_t maddr;
	byte chip_version;
	int slot;
	byte value;

        if (cf->cf_unit != 0) {
                printf("multiple PCMCIA controllers never tried before...\n");
                return (0);
        }

	ioaddr = ia->ia_iobase;
	maddr = ia->ia_maddr;
	chip_version = PCIC_Read(ioaddr, PCIC_ID_AND_REVISION_REG);

	/* see if this looks like a PCIC chip... */
	if (( chip_version & 0xf0 ) != 0x80 ) {
	  printf("pcmcia%d: i82365sl not found at base 0x%x!\n", cf->cf_unit, 
		 ioaddr);
	  printf("     ID value returned was 0x%x\n", chip_version);
	  return (0);
	}

	/* mask so we just have the version number left */
	chip_version &= 0x0f;

	/* ok, so we found the chip, announce our intentions... */
	printf("pcmcia%d: chip version %d at base 0x%x maddr 0x%x\n",
		cf->cf_unit, chip_version, ioaddr, maddr);

        /* Ok, so we have a chip, do per-slot stuff */ 

	/* we assume config file has flags set to 0 for checking one slot
	   only, or 1 for checking both slots! */
	if ( !((cf->cf_flags == 0) || (cf->cf_flags == 1))) {
		printf(" --> invalid pcmcia flags in config file!\n");
		return (0);
	}

	for (slot=0; slot <= cf->cf_flags; slot++)
	{
	  value = PCIC_Read(ioaddr, (slot * 0x40) + PCIC_INTERFACE_STATUS_REG);
	  if (value & 0x0c)
	  {
	    switch (slot) {
		case SLOT_MEGAHERTZ:
		    printf("  slot%d: card in slot %c configured for Megahertz modem\n", slot, ('A'+slot));
		    pcic_mhz_hack(slot);
		    break;
		case SLOT_DLINK:
		    printf("  slot%d: card in slot %c configured for D-Link Ethernet adapter\n", slot, ('A'+slot));
		    pcic_dlink_hack(slot);
		    break;
		default:
		    printf("  slot%d: not configured for any device!\n", slot);
		    break;
	    }
	  } else {
	    printf("  slot%d: nothing\n",slot);
	  }
	}

	return (0);
}

int
card_valid(int slot, int slot_offset)
{
        unsigned Temp_Data;
        char Card_Detect;

        /* TRY TO WRITE AND THEN READ BACK FROM A REGISTER IN THE
           CURRENT SLOT.  IF YOU READ WHAT YOU WROTE, SLOT IS VALID.  */
        Temp_Data = PCIC_In( PCIC_IO_ADDR_0_START_REG_LOW );
        PCIC_Out( PCIC_IO_ADDR_0_START_REG_LOW, 0x55 );
        if( PCIC_In(PCIC_IO_ADDR_0_START_REG_LOW) == 0x55 ) {
                PCIC_Out( PCIC_IO_ADDR_0_START_REG_LOW, Temp_Data );
		printf("    Slot %c valid, ", slot);
        } else {
	    printf( "    Slot %c is not valid.\n", slot);
	    return;
	}

        /* CHECK CARD DETECT SIGNALS - IS A CARD INSERTED?	*/
        Card_Detect = PCIC_In( PCIC_INTERFACE_STATUS_REG );
        if(!(Card_Detect & 0x0C)) {
                printf( "card not detected.\n");
                return;
        }
	printf("card detected.\n");
}

void
pcic_mhz_hack(int configured_slot)
{
        int i;
        unsigned uCom_Adr[] = { 0x03f8, 0x02f8, 0x03e8, 0x02e8 };
        int nComPortNum = 2;
        int inter;
        int ioaddr;
        char slot = 'A' + configured_slot;
        int slot_offset = 0x00 + (0x40 * configured_slot);
        int sys_mem0_addr, addr;
	caddr_t p;

	if (!card_valid(slot, slot_offset)) return;

        /* PREPARE TO SET PCIC REGISTERS */
        switch( nComPortNum )
        {
                case 1: ioaddr = 0x3f8;
                        inter = 0x64;   /* i/o card and IRQ4 */
                        reg0_val = 0x20;
                        break;
                case 2: ioaddr = 0x2f8;
                        inter = 0x63;   /* i/o card and IRQ3 */
                        reg0_val = 0x21;
                        break;
                case 3: ioaddr = 0x3e8;
                        inter = 0x64;   /* i/o card and IRQ4 */
                        reg0_val = 0x22;
                        break;
                case 4: ioaddr = 0x2e8;
                        inter = 0x63;   /* i/o card and IRQ3 */
                        reg0_val = 0x23;
                        break;
        }

        /* SAY CARD IS I/O TYPE AND STEER INTERRUPT TO IRQ3 OR IRQ4 */
        PCIC_Out(PCIC_INTERRUPT_AND_CONTROL_REG, inter);

        /* DATA PATH WIDTH AND WAIT STATE STUFF */
        PCIC_Out(PCIC_IO_CONTROL_REG, 0x0);

        /* TELL CARD WHAT RANGE OF IO ADDRESSES TO USE FOR EMULATING UART */
	PCIC_Out16(PCIC_IO_ADDR_0_START_REG_LOW, ioaddr);
	PCIC_Out16(PCIC_IO_ADDR_0_STOP_REG_LOW,  ioaddr+0x07);

        /* SET UP MAPPING OF ATTRIBUTE MEMORY INTO SYSTEM MEMORY SPACE */
        sys_mem0_addr = uSysMemPage >> 8;
	PCIC_Out16(PCIC_SYS_MEM_ADDR_0_MAP_START_LOW, sys_mem0_addr);
        PCIC_Out16(PCIC_SYS_MEM_ADDR_0_MAP_STOP_LOW, sys_mem0_addr);
        PCIC_Out16(PCIC_CARD_MEM_OFF_ADDR_0_LOW, (((-sys_mem0_addr) & 0x0FFF) | 0x5000));

        /* POWER CARD ON */
        PCIC_Out(PCIC_POWER_RESETDRV_CONTROL_REG, 0xd0);

        DELAY( 1000000 );    /* wait for power to come up */

        /* enable windows */
        PCIC_Out(PCIC_ADDR_WIN_ENABLE_REG, 0x41);
        /* reset card */
        PCIC_Out(PCIC_INTERRUPT_AND_CONTROL_REG, (0xbf & inter));
        DELAY( 100000 );
        outb( PCIC_DATA, inter );

        /* Enable modem card */
	/* uSysMemPage is something like 0xd000, a segment register value. */
	p = ISA_HOLE_VADDR( (uSysMemPage << 4) + 0x100 );
	*p = reg0_val;

        /* disable memory window */
        PCIC_Out(PCIC_ADDR_WIN_ENABLE_REG, 0x40);

        /* wait for modem to initialize */
        DELAY(500000);

        {
        unsigned char temp;
        temp = inb(uCom_Adr[nComPortNum - 1] + 0x04);
        outb((uCom_Adr[nComPortNum-1] + 0x04), temp); /* fix to run XTALK4 */
        }
}

void
pcic_dlink_hack(int configured_slot)
{
        int i;
        int ioaddr;
        int inter;
        char slot = 'A' + configured_slot;
        int slot_offset = 0x00 + (configured_slot * 0x40);
        int sys_mem0_addr, addr;
	caddr_t p;

	if (!card_valid(slot, slot_offset)) return;

	/* power cycle the card */
        PCIC_Out(PCIC_POWER_RESETDRV_CONTROL_REG, PWR_OFF);
	DELAY(300000);
        PCIC_Out(PCIC_POWER_RESETDRV_CONTROL_REG, (PWR_OUT|PWR_NORESET|VCC_5V));
	DELAY(1000000);

	/*
	 * Config entry for D-Link is hardwired like so:
	 *     device ed0 at isa? port 0x300 irq 10
	 * I/O base address is 0x300
	 * IRQ is 10
	 * Flags 650 tells modified NE-1000/NE-2000 driver it is a DE-650
	 */
	ioaddr = dlink_ioaddr = 0x300;
	inter = 10;				/* hardwired to IRQ10 */
	reg0_val = 0x41;
	PCIC_Out16(PCIC_IO_ADDR_0_START_REG_LOW, ioaddr);
	PCIC_Out16(PCIC_IO_ADDR_0_STOP_REG_LOW,  ioaddr+0x0F);
	PCIC_Out16(PCIC_IO_ADDR_1_START_REG_LOW, ioaddr+0x10);
	PCIC_Out16(PCIC_IO_ADDR_1_STOP_REG_LOW,  ioaddr+0x1F);

	/* The 8390 ports are 8-bit, but the DMA port is 16-bit */
	PCIC_Out(PCIC_IO_CONTROL_REG, (IOCTL_1_CS16|IOCTL_1_16BIT));

        /* SET UP MAPPING OF ATTRIBUTE MEMORY INTO SYSTEM MEMORY SPACE */
        sys_mem0_addr = uSysMemPage >> 8;
        PCIC_Out16(PCIC_SYS_MEM_ADDR_0_MAP_START_LOW, sys_mem0_addr);
        PCIC_Out16(PCIC_SYS_MEM_ADDR_0_MAP_STOP_LOW, sys_mem0_addr);
	PCIC_Out16(PCIC_CARD_MEM_OFF_ADDR_0_LOW, (((-sys_mem0_addr) & 0x0FFF) | 0x5000));

	/* turn on i/o and memory window */
        PCIC_Out(PCIC_ADDR_WIN_ENABLE_REG, (0x20|ENA_IO_1|ENA_IO_0|ENA_MEM_0));

	/* set the cards irq */
        PCIC_Out(PCIC_INTERRUPT_AND_CONTROL_REG, (PC_RESET|PC_IOCARD|inter));

	/* grab the ethernet address */
	printf("dl650: ethernet address:");
	p = ISA_HOLE_VADDR( (uSysMemPage << 4) + 0x40 );
	for (i = 0; i < ETHER_ADDR_LEN; i++) {
	    dlink_eth_addr[i] = *(unsigned char *)(p+(i<<1));
	    printf("%s%02x", (i? ":": " "), dlink_eth_addr[i]);
	}
	printf("\n");

	/* reset the card */
        PCIC_Out(PCIC_INTERRUPT_AND_CONTROL_REG, (PC_IOCARD|inter));
	DELAY(5000);
        PCIC_Out(PCIC_INTERRUPT_AND_CONTROL_REG, (PC_RESET|PC_IOCARD|inter));

	p = ISA_HOLE_VADDR( (uSysMemPage << 4) + 0x08 );
	*p = 0x80;
	DELAY(50000);

	/* enable the card */
	p = ISA_HOLE_VADDR( (uSysMemPage << 4) + 0x08 );
	*p = reg0_val;

	/* turn off memory window? */
        PCIC_Out(PCIC_ADDR_WIN_ENABLE_REG, (0x20|ENA_IO_1|ENA_IO_0)); /**/

	DELAY(500000);
}

#endif /* NPCMCIA > 0 */

