/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


/* Reading and writing to files
 * -brewster 5/10/90
 */

#ifndef IRCFILEIO_H
#define IRCFILEIO_H

#include "cdialect.h"
#include "futil.h"
#include "zprot.h"

#define MAX_SYMBOL_SIZE 255
#define END_OF_STRUCT_OR_LIST 6

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

long SkipObject (FILE* file);

long ReadLong (FILE* file,long* num);

long ReadDouble (FILE* file,double* num);

long ReadSymbol (char* string, FILE* file, long string_size);

long ReadString (char* string, FILE* file, long string_size);

long CheckStartOfStruct (char* name, FILE* file);

long ReadAny (any* destination, FILE* file);

long ReadTM (struct tm* time, FILE* file);

long Read8BitArray (char* destination, FILE* file, long length);

long ReadEndOfListOrStruct (FILE* file);

long ReadStartOfStruct (char* name, FILE* file);

Boolean ReadStartOfList (FILE* file);

Boolean ReadEndOfList (FILE* file);

Boolean	readAbsoluteTime (struct tm* time,FILE* file);

/* writing */

long WriteStartOfStruct (char* name, FILE* file);

long WriteEndOfStruct (FILE* file);

long WriteSymbol (char* name, FILE* file);

long WriteString (char* string, FILE* file);

long WriteNewline (FILE* file);

long WriteLong (long number, FILE* file);

long WriteDouble (double number, FILE* file);

long WriteAny (any* value, FILE* file);

long Write8BitArray (long length, char* array, FILE* file);

long WriteTM (struct tm* time, FILE* file);

long WriteStartOfList (FILE* file);

long WriteEndOfList (FILE* file);

Boolean	writeAbsoluteTime (struct tm* time,FILE* file); 


#ifdef __cplusplus
	}
#endif /* def __cplusplus */

#endif /* def IRCFILEIO_H */
