.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "11-oct-92" "X Version 11"
.SH NAME
xscreensaver - run graphics hacks after the user has been idle for a while
.SH SYNOPSIS
.B xscreensaver
[\-display \fIhost:display.screen\fP] [\-timeout \fIint\fP] [\-cycle \fIint\fP] [\-nice \fIint\fP] [\-verbose] [\-silent] [\-xidle] [\-no-xidle] [\-xrm \fIresources\fP]
.SH DESCRIPTION
The \fIxscreensaver\fP program waits until the keyboard and mouse have been 
idle for a period, and then runs a graphics demo chosen at random.  It 
turns off as soon as there is any mouse or keyboard activity.

This is not a screen locker, like \fIxlock\fP -- it does not prevent others 
from using your terminal.  Its purpose is to display pretty pictures on 
your screen when it is not in use.

The benefit that this program has over the combination of the \fIxlock\fP 
and \fIxautolock\fP programs is the ease with which new graphics hacks can
be installed.  You don't need to recompile this program to add a new 
display mode.
.SH OPTIONS
.I xscreensaver
accepts the following options:
.TP 8
.B \-timeout minutes
The screensaver will activate after the keyboard and mouse have been idle
for this many minutes.
.TP 8
.B \-cycle minutes
After the screensaver has been running for this many minutes, the currently
running sub-process will be killed (with \fBSIGTERM\fP), and a new one 
started.  If this is 0, then the sub-process will not be killed; only one
demo will run until the screensaver is deactivated by user activity.
.TP 8
.B \-nice integer
The sub-processes created by \fIxscreensaver\fP will be ``niced'' to this
level, so that they do not consume cycles that are needed elsewhere.
.TP 8
.B \-verbose
Print diagnostics.
.TP 8
.B \-silent

.TP 8
.B \-xidle
Use the \fIXIdle\fP server extension to decide whether the user is idle.
This is the default if \fIxscreensaver\fP has been compiled with support
for XIdle.  The XIdle method is faster and more reliable than what will
be done otherwise, so use it if you can.  
.TP 8
.B \-no-xidle
Don't use \fIXIdle\fP.
.SH X DEFAULTS
\fIxscreensaver\fP understands the following resources:
.PP
.TP 8
.B timeout (\fPclass\fB Time)
Same as the \fI\-timeout\fP command-line option.  Default 10 minutes.
.TP 8
.B cycle (\fPclass\fB Time)
Same as the \fI\-cycle\fP command-line option.  Default 10 minutes.
.TP 8
.B nice (\fPclass\fB Nice)
Same as the \fI\-nice\fP command-line option.  Default 10.
.TP 8
.B verbose (\fPclass\fB Boolean)
Same as the \fI\-verbose\fP command-line option.
.TP 8
.B xidle (\fPclass\fB Boolean)
Same as the \fI\-xidle\fP command-line option.
.TP 8
.B fade (\fPclass\fB Boolean)
If this is true, then when the screensaver activates, the current contents
of the screen will fade to black instead of simply winking out.  This only
works on displays with writable colormaps.  Default true.  A fade will also
be done when switching graphics hacks (when the \fIcycle\fP timer expires.)
.TP 8
.B unfade (\fPclass\fB Boolean)
If this is true, then when the screensaver deactivates, the original contents
of the screen will fade in from black instead of appearing immediately.  This
only works on displays with writable colormaps, and if \fIfade\fP is true
as well.  Default false.
.TP 8
.B fadeSeconds (\fPclass\fB Time)
If \fIfade\fP is true, this is how long the fade will be in 
seconds (default 1.)
.TP 8
.B fadeTicks (\fPclass\fB Integer)
If \fIfade\fP is true, this is how many times a second the colormap will
be changed to effect a fade.  Higher numbers yield smoother fades, but
may make the fades take longer if your server isn't fast enough to keep
up.  Default 75.
.TP 8
.B installColormap (\fPclass\fB Boolean)
Whether a new colormap should be installed while the screensaver is on,
so that the graphics hacks can get as many colors as possible.  Default
true.
.TP 8
.B programs (\fPclass\fB Programs)
The graphics hacks which \fIxscreensaver\fP runs when the user is idle.
The value of this resource is a string, one \fIsh\fP command per line.
Each line must contain exactly one command -- no semicolons.

When the screensaver starts up, one of these is selected at random, and
run.  After the \fIcycle\fP period expires, it is killed, and another
is selected and run.

If the value of this resource is empty, then no programs will be run;
the screen will simply be made black.

Note that you must escape the newlines; here is an example of how you
might set this in your \fI.Xdefaults\fP file:
.EX
xscreensaver.programs:  \\
        qix -root                        \\n\\
        ico -r -faces -sleep 1 -obj ico  \\n\\
        xdaliclock -builtin2 -root       \\n\\
        xwave -root
.EE
To use a program as a screensaver, two things are required: that that
program draw on the root window (or be able to be configured to draw on
the root window); and that that program understand ``virtual root''
windows, as used by virtual window managers such as \fItvtwm\fP.

It is quite easy to make programs understand virtual roots if they
don't already: you merely need to include the file \fI"vroot.h"\fP in
them after the standard X includes, and recompile.  This file is distributed
with X11r5, and is included with xscreensaver as well.
.PP
Normally you won't need to change the following resources:
.TP 8
.B bourneShell (\fPclass\fB BourneShell)
The pathname of the shell that \fIxscreensaver\fP uses to start subprocesses.
This must be whatever your local variant of \fB/bin/sh\fP is -- in particular,
it must not be \fBcsh\fP.
.TP 8
.B windowCreationTimeout (\fPclass\fB Time)
When \fIXIdle\fP is not in use, this controls the delay between when 
windows are created and when \fIxscreensaver\fP selects events on them.
Default 30 seconds.
.TP 8
.B pointerPollTime (\fPclass\fB Time)
When \fIXIdle\fP is not in use, this controls how frequently \fIxscreensaver\fP
checks to see if the mouse position or buttons have changed.  Default 5 seconds.
.TP 8
.B initialDelay (\fPclass\fB Time)
When \fIXIdle\fP is not in use, \fIxscreensaver\fP will wait this many seconds
before selecting events on existing windows, under the assumption that 
\fIxscreensaver\fP is started during your login procedure, and the window 
state may be in flux.  Default 30 seconds.
.SH "HOW IT WORKS"
When it is time to activate the screensaver, a full-screen black window is
created.  This window is given the appropriate properties so that, to any 
subsequently-created programs, it will appear to be a ``virtual root'' 
window.  Because of this, any program which draws on the root window (and 
which understands virtual roots) can be used as a screensaver.
.PP
When the user becomes active again, the screensaver window is unmapped and
the running subprocess is killed by sending it \fBSIGTERM\fP.  This is also
how the subprocesses are killed when the screensaver decides that it's time
to run a different demo: the old one is killed and a new one is launched.
.PP
Before launching a subprocess, \fIxscreensaver\fP stores an appropriate value
for \fB$DISPLAY\fP in the environment that the child will recieve.  (This is
so that if you start \fIxscreensaver\fP with a \fI-display\fP argument, the
programs which \fIxscreensaver\fP launches will draw on the same display.)
.PP
When the screensaver turns off, or is killed, care is taken to restore 
the ``real'' virtual root window if there is one.  Because of this, it is
important that you not kill the screensaver process with \fIkill -9\fP if
you are running a virtual-root window manager.  If you kill it with \-9,
you may need to restart your window manager to repair the damage.  This
isn't an issue if you aren't running a virtual-root window manager.
.PP
For all the gory details, see the commentary at the top of xscreensaver.c.
.PP
You can control a running screensaver process by using
the \fIscreensaver-command\fP program (which see.)
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1),
xscreensaver-command(1),
xlock(1),
xnlock(1),
xautolock(1),
qix(1),
pyro(1),
helix(1),
rorschach(1),
hopalong(1),
attraction(1),
greynetic(1),
rocks(1),
noseguy(1),
blitspin(1),
imsmap(1),
ico(1),
xdaliclock(1),
xbouncebits(1),
xswarm(1),
xwave(1),
aquarium(1)
.SH BUGS
If you are not using \fIXIdle\fP, and an application does not 
select \fBKeyPress\fP events on its non-leaf windows within the first
30 seconds of their existence, but selects them later, then it is 
possible that \fIxscreensaver\fP could interfere with the propagation
of those events.  This isn't very likely, but this is the reason that
it's a good idea to install the \fIXIdle\fP extension.
.PP
Although this program ``nices'' the subprocesses that it starts, 
graphics-intensive subprograms can still overload the machine by causing
the X server process itself to suck a lot of cycles.  Care should be taken
to slow down programs intended for use as screensavers by inserting 
strategic calls to \fIsleep()\fP or \fIusleep()\fP.
.PP
If the subprocess is drawing too quickly and the connection to the X
server is a slow one (such as an X terminal running over a phone line) then 
the screensaver might not turn off right away when the user becomes active
again (the \fIico\fP demo has this problem if being run in full-speed mode).
This can be alleviated by inserting strategic calls to \fIXSync()\fP in code 
intended for use as a screensaver.  This prevents too much graphics activity 
from being buffered up.
.PP
The screensaver only runs on the default screen of the display.  If you have
more than one screen, you must run multiple screensaver processes, one for
each screen.  (I don't actually know whether this works, because I don't 
have access to a multi-screen machine.  Comments welcome.)
.PP
It wouldn't be too hard to make this able to lock screens as well.
.PP
There need to be a lot more graphics hacks.  In particular, there should be
a simulation of a Lavalite (tm).
.PP
Apparently there are some problems with ``XView'' programs getting confused
and thinking that the screensaver window is the real root window even when
the screensaver is not active: ClientMessages intended for the window manager
are sent to the screensaver window instead.  This could be solved by making
xscreensaver forward all unrecognised ClientMessages to the real root window,
but there may be other problems as well.
.SH COPYRIGHT
Copyright 1992 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@lucid.com>, 13-aug-92.
Please let me know if you find any bugs or make any improvements.
