.TH XScreenSaver 1 "17-aug-92" "X Version 11"
.SH NAME
blitspin - rotate a bitmap in an interesting way
.SH SYNOPSIS
.B blitspin
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP] [\-background \fIcolor\fP] [\-window] [\-root] [\-mono] [\-bitmap \fIfilename\fP] [\-delay \fIusecs\fP] [\-delay2 \fIusecs\fP]
.SH DESCRIPTION
The \fIblitspin\fP program repeatedly rotates a bitmap by 90 degrees by
using logical operations: the bitmap is divided into quadrants, and the
quadrants are shifted clockwise.  Then the same thing is done again with
progressively smaller quadrants, except that all sub-quadrants of a 
given size are rotated in parallel.  So this takes \fBO(16*log2(N))\fP 
blits of size NxN, with the limitation that the image must be square,
and the size must be a power of 2.
.SH OPTIONS
.I blitspin
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-bitmap bitmap-name
The bitmap to rotate.  It need not be square: it will be padded with
the background color.  Default is \fIxlogo64\fP, but \fIescherknot\fP
is also nice.  You really need to run this on a bigger bitmap than
those shipped with the X distribution to do it justice.

The \fB*bitmapFilePath\fP resource will be searched if the bitmap name
is not a fully-qualified pathname.
.SH ENVIRONMENT
.PP
.TP 8
.B \-delay microseconds
How long to delay between steps of the rotation process, in microseconds.
Default is 500000, one-half second.
.PP
.TP 8
.B \-delay2 microseconds
How long to delay between each 90-degree rotation, in microseconds.
Default is 500000, one-half second.
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1),
xscreensaver(1)
.SH COPYRIGHT
Copyright 1992 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@lucid.com>, 17-aug-92.

Based on SmallTalk code which appeared in the August 1981 issue of Byte
magazine.
