/*
 * year menu widgets.
 *
 *	destroy_year_menu()		Destroy the year window an its
 *					contents
 *	create_year_menu()		Create a year calendar for curr_year
 *					and put a year view into it
 *	destroy_year_view()		Destroy year view, to make room for
 *					another view in the mainwindow
 *	create_year_view(parent)	Create a form widget for the year
 *					view, and everything in it.
 */

#ifndef MIPS
#include <stdlib.h>
#endif
#include <stdio.h>
#include <time.h>
#include <varargs.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelP.h>
#include <Xm/ArrowBP.h>
#include <Xm/ArrowBG.h>
#include <Xm/PushBP.h>
#include <Xm/PushBG.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>
#include <Xm/Protocols.h>
#include "cal.h"

static void done_callback(), year_cal_callback();
extern void help_callback();
extern time_t length_of_month();

extern Display		*display;	/* everybody uses the same server */
extern GC		gc;		/* everybody uses this context */
extern Widget		toplevel;	/* top-level shell */
extern struct mainmenu	mainmenu;	/* all important window widgets */
extern struct config	config;		/* global configuration data */
extern struct list	*mainlist;	/* list of all schedule entries */
extern XFontStruct	*font[NFONTS];	/* fonts: FONT_* */
extern Pixel		color[NCOLS];	/* colors: COL_* */

static BOOL		have_shell;	/* year window is being displayed */
static Widget		shell;
static BOOL		have_view;	/* <all> is a valid widget */
static Widget		all;		/* the form that contains everything */


/*
 * destroy the year menu. Remove it from the screen, and destroy its widgets.
 * It's too much trouble to keep them for next time.
 */

destroy_year_menu()
{
	if (have_shell) {
		XtPopdown(shell);
		XTDESTROYWIDGET(shell);
		have_shell = FALSE;
		mainmenu.yearcal = 0;
	}
}


/*
 * create the year menu.
 * There should be buttons for Quit, next/prev year, next/prev 6 months.
 */

create_year_menu()
{
	Arg			args[5];
	int			n;
	Atom			closewindow;
	BOOL			had_view = have_view;

	if (have_shell) {
		XtPopup(shell, XtGrabNone);
		XRaiseWindow(display, XtWindow(shell));
		draw_year_calendar();
		return;
	}
	n = 0;
	XtSetArg(args[n], XmNdeleteResponse,	XmDO_NOTHING);		n++;
	XtSetArg(args[n], XmNiconic,		False);			n++;
	shell = XtAppCreateShell("Year Calendar", "plan",
			applicationShellWidgetClass, display, args, n);
#	ifdef EDITRES
	XtAddEventHandler(shell, (EventMask)0, TRUE, 
 			_XEditResCheckMessages, NULL);
#	endif
	set_icon(shell, 0);

	create_year_view(shell);

	XtPopup(shell, XtGrabNone);
	closewindow = XmInternAtom(display, "WM_DELETE_WINDOW", False);
	XmAddWMProtocolCallback(shell, closewindow,
					done_callback, (XtPointer)shell);
	have_shell = TRUE;
	have_view  = had_view;
}


/*
 * destroy the contents of the year view. This is used when the year view is
 * in the mainwindow, not in its own window, and another view is requested.
 */

destroy_year_view()
{
	if (have_view) {
		XTDESTROYWIDGET(all);
		have_view = FALSE;
	}
}


/*
 * create a form and all year widgets in that form. This is called from two
 * places: from create_year_menu above if a year view in its own window is
 * created, and from caldraw.c if a year view is to be displayed in the
 * mainwindow.
 */

create_year_view(parent)
	Widget			parent;
{
	Arg			args[15];
	int			n;
	Widget			scroll;

	all = XtCreateWidget("yearform", xmFormWidgetClass,
			parent, NULL, 0);
	XtAddCallback(all, XmNhelpCallback, help_callback, (XtPointer)"year");

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset,		8);			n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		2*config.year_margin+
						4*config.yearbox_xs*7+
						3*config.year_gap +4);	n++;
	XtSetArg(args[n], XmNheight,		2*config.year_margin+
						1*config.year_title +
						3*config.yearbox_ys*8+
						3*config.year_gap +4);	n++;
	XtSetArg(args[n], XmNscrollingPolicy,	XmAUTOMATIC);		n++;
	scroll = XtCreateWidget("scroll", xmScrolledWindowWidgetClass,
			all, args, n);

	n = 0;
	XtSetArg(args[n], XmNwidth,		2*config.year_margin+
						4*config.yearbox_xs*7+
						3*config.year_gap);	n++;
	XtSetArg(args[n], XmNheight,		2*config.year_margin+
						1*config.year_title +
						3*config.yearbox_ys*8+
						3*config.year_gap);	n++;
	mainmenu.yearcal = XtCreateWidget("yearcal", xmDrawingAreaWidgetClass,
			scroll, args, n);
	XtAddCallback(mainmenu.yearcal, XmNinputCallback,
					year_cal_callback, (XtPointer)NULL);
	XtAddCallback(mainmenu.yearcal, XmNexposeCallback,
					year_cal_callback, (XtPointer)NULL);

	XtManageChild(mainmenu.yearcal);
	XtManageChild(scroll);
	XtManageChild(all);
}


/*-------------------------------------------------- callbacks --------------*/
/*
 * All of these routines are direct X callbacks.
 */

/*ARGSUSED*/
static void done_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	destroy_year_menu();
}


/*ARGSUSED*/
static void year_cal_callback(w, data, info)
	Widget				w;
	XtPointer			data;
	XmDrawingAreaCallbackStruct	*info;
{
	if (info->reason == XmCR_INPUT && info->event->xany.type ==ButtonPress)
		clicked_year_calendar(info->event->xbutton.x,
				      info->event->xbutton.y);
	else if (info->reason == XmCR_EXPOSE) {
		XEvent dummy;
		while (XCheckWindowEvent(display, info->window, ExposureMask,
								&dummy));
		draw_year_calendar();
	}
}
