/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * net.h: system specific networking definitions
 * 
 * Rob McCool
 */


#ifndef NET_H
#define NET_H

#ifdef __cplusplus
extern "C" {
#endif

#include "systems.h"

#include "file.h"       /* for client file descriptors */
#include "pblock.h"     /* for client data block */


#ifdef NET_WINSOCK
#include <winsock.h>

#else
#include <sys/types.h>  /* FD_SET */
#if !defined(SUNOS4) && !defined(HPUX) && !defined(LINUX)
#include <sys/select.h>
#endif
#include <sys/time.h>    /* struct timeval */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> /* sockaddr and in_addr */
#include <sys/uio.h>
#endif


/* This should be a user-given parameter later */
#define NET_BUFFERSIZE 8192
/* So should this. */
#define NET_READ_TIMEOUT 120
#define NET_WRITE_TIMEOUT 300
#define NET_INFINITE_TIMEOUT 0
#define NET_ZERO_TIMEOUT -1

#define SSL_HANDSHAKE_TIMEOUT 300


/* ------------------------------ Data types ------------------------------ */


typedef int SYS_NETFD;
#define SYS_NET_ERRORFD (-1)


/* -------------------------------- Global -------------------------------- */


extern int net_enabledns;
extern int net_listenqsize;


int net_accept_init(int port);
void net_accept_terminate(void);
void net_accept_enter(void);
int net_accept_tenter(void);
void net_accept_exit(void);
void net_accept_texit(void);





/* ------------------------------ Prototypes ------------------------------ */


NSAPI_PUBLIC
int net_init(int security);

NSAPI_PUBLIC
SYS_NETFD net_socket(int domain, int type, int protocol);

NSAPI_PUBLIC
int net_getsockopt(SYS_NETFD s, int level, int optname, void *optval,
                   int *optlen);

NSAPI_PUBLIC
int net_setsockopt(SYS_NETFD s, int level, int optname, const void *optval,
                   int optlen);
NSAPI_PUBLIC int net_listen(SYS_NETFD s, int backlog);
NSAPI_PUBLIC SYS_NETFD net_create_listener(char *ipaddr, int port);

NSAPI_PUBLIC int net_select(int nfds, fd_set *r, fd_set *w, fd_set *e, 
                            struct timeval *timeout);
NSAPI_PUBLIC int net_connect(SYS_NETFD s, const void *sockaddr, int namelen);
NSAPI_PUBLIC int net_ioctl(SYS_NETFD s, int tag, void *result);

NSAPI_PUBLIC
int net_getpeername(SYS_NETFD s, struct sockaddr *name, int *namelen);
NSAPI_PUBLIC int net_close(SYS_NETFD s);

NSAPI_PUBLIC
int net_bind(SYS_NETFD s, const struct sockaddr *name, int namelen);

NSAPI_PUBLIC
SYS_NETFD net_accept(SYS_NETFD s, struct sockaddr *addr, int *addrlen);

NSAPI_PUBLIC int net_read(SYS_NETFD sd, char *buf, int sz, int timeout);
NSAPI_PUBLIC int net_write(SYS_NETFD sd, char *buf, int sz);
#ifdef NET_WINSOCK
struct iovec {
	char		*iov_base;
    unsigned	iov_len;
};
#endif
NSAPI_PUBLIC int net_writev(SYS_NETFD sd, struct iovec *iov, int iovlen);

NSAPI_PUBLIC int net_makenonblocking(SYS_NETFD sd);

/*
 * net_isalive checks to see if the given sd is still connected to a remote
 * host. It returns 0 if the socket is no longer connected, or 1 if it is
 * still there. The remote host will not see any side effects.
 */
NSAPI_PUBLIC int net_isalive(SYS_NETFD sd);

/*
 * net_ip2host transforms the given textual IP number into a FQDN. If it
 * can't find a FQDN, it will return what it can get. Otherwise, NULL.
 *
 * verify is whether or not the function should verify the hostname it 
 * gets. This takes an extra query but is safer for use in access control.
 */

NSAPI_PUBLIC char *net_ip2host(char *ip, int verify);

#ifdef __cplusplus
}
#endif

#endif
