/*
 * schedule.c : NBA Schedule for 1993-94 season
 *
 * Compiled by Christopher McAvaney, chrismc@deakin.edu.au, 23 Sep 1993.
 *
 * This file defines the teams, the schedule matrix, and special dates.
 * It is the only file you should have to change for a new season.
 *
 * See the file UPDATING file for instructions on updating this for a
 * new season.
 *
 * This file is included directly by schedule.c. Don't bug me about it...
 */

/*
 * Set this to something informative about the league and season
 * represented by this file. It is used for the -v option.
 */
#define VERSION_SEASON  "NBA 93-94"
#define VERSION_ENTERER "Christopher McAvaney, chrismc@deakin.edu.au"

/*
 * Set these to the starting and ending dates of the season.
 * They have to be strings (ie., enclosed in double-quotes) and
 * should be in form MM/DD/YYYY (the year must be all four digits).
 * The START_DOW should be a capitalized string representing the
 * day-of-the-week for the START_DATE. Check weekday[] in nhl.c for spelling.
 */
#define START_DATE		"11/5/1993"
#define START_DOW		"Friday"
#define END_DATE		"4/24/1994"

/*
 * The list of teams referenced by the schedule[] array.
 */
#define NUM_TEAMS 27

struct _team_struct {
    char *city;					/* City name for team */
    char *name;					/* Team nickname */
    char *abbrev;				/* Team code for cmd-line */
} teams[NUM_TEAMS] = {
    { "Atlanta",	"Hawks",	"atl" },
    { "Boston",		"Celtics",	"bos" },
    { "Charlotte",	"Hornets",	"cha" },
    { "Chicago",	"Bulls",	"chi" },
    { "Cleveland",	"Cavs",		"cle" },
    { "Dallas",		"Mavericks",	"dal" },
    { "Denver",		"Nuggets",	"den" },
    { "Detroit",	"Pistons",	"det" },
    { "Golden State",	"Warriors",	"g.s" },
    { "Houston",	"Rockets",	"hou" },
    { "Indiana",	"Pacers",	"ind" },
    { "Los Angeles",	"Clippers",	"lac" },
    { "Los Angeles",	"Lakers",	"lal" },
    { "Miami",		"Heat",		"mia" },
    { "Milwaukee",	"Bucks",	"mil" },
    { "Minnesota",	"Timberwolves",	"min" },
    { "New Jersey",	"Nets",		"nj"  },
    { "New York",	"Knicks",	"ny"  },
    { "Orlando",	"Magic",	"orl" },
    { "Philadelphia",	"76ers",	"phi" },
    { "Phoenix",	"Suns",		"pho" },
    { "Portland",	"Trailblazers",	"por" },
    { "Sacramento",	"Kings",	"sac" },
    { "San Antonio",	"Spurs",	"san" },
    { "Seattle",	"Supersonics",	"sea" },
    { "Utah",		"Jazz",		"uta" },
    { "Washington",	"Bullets",	"was" },
};

#define NUM_DIVISIONS 4
#define MAX_TEAMS_PER_DIVISION 8

struct _division_struct {
    char *name;					/* Division name */
    char *teams[MAX_TEAMS_PER_DIVISION];	/* List of team abbrevs */
    char *abbrev;				/* Division abbrev */
    char flags[NUM_TEAMS];			/* Array of flags for teams */
} divisions[NUM_DIVISIONS] = {
    { "Pacific",  { "sea","por","sac","g.s","lac","lal",NULL,NULL },   "pac" },
    { "Mid West", { "hou","uta","pho","dal","den","san",NULL,NULL },   "mdw" },
    { "Central",  { "chi","mil","atl","cle","det","min","ind",NULL },  "ctl" },
    { "Atlantic", { "bos","cha","mia","nj","ny","orl","phi","was" },   "atc" },
};

/*
 * Special dates for which there are no games this season:
 */
struct _special_struct {
    int month,day;					/* Date */
    char *text;						/* Message to print */
} special_dates[] = {
    {  2, 11, "All-Star weekend" },
    {  2, 12, "All-Star weekend" },
    {  2, 13, "All-Star Game at Minnesota" },
    {  0,  0, NULL },
};

/*
 * The list of home team extra info referenced in the schedule[] array
 */
char *extra_info[] = {
    NULL,
};

/*
 * Schedule matrix:
 *   Each string represents one day of the season, The Nth character in
 *   the string represents what the Nth team (in the teams[] array) is
 *   doing on that day. The entries are interpreted as follows:
 *	-   : This team is idle
 *	+   : This team is home
 *     a-z0 : This team is away at the team given by the letter
 *      A-Z : Team is the home team and extra_info corresponding to the
 *	      letter applies to the game. (doesn't apply for NBA)
 *
 *   Accessors are defined here for accessing the array. The accessors have
 *   to map from the characters used in schedule[] into the teams[] and
 *   extra_info[] arrays. They needn't be contiguous, but it makes life
 *   easier if they are.
 */

#define ISIDLECODE(C)	((C) == '-')
#define ISHOMECODE(C)	((C) == '+')
#define ISAWAYCODE(C)	(((C) >= 'a' && (C) <= 'z') || ((C) =='0'))
#define ISINFOCODE(C)	((C) >= 'A' && (C) <= 'Z')

#define TEAMCODETOINDEX(C)	((int)(((C)>='a') ? ((C)-'a') : ((C) -'0'+26)))
#define INDEXTOTEAMCODE(N)	((char)(((N)>=26) ? ((N)-26+'0') : ((N)+'a')))

#define INFOCODETOINDEX(C)	((int)((C) - 'A'))
#define INDEXTOINFOCODE(N)	((char)((N) + 'A'))

char *schedule[] = {
    "+++c+zw+x+a+++ehjbn+ml++-+t", /* 11/5 */
    "-0o+-+-kf-+-yd++--+s----+p+", /* 11/6 */
    "----+-+--v-g----xe--++u+---", /* 11/7 */
    "d+-+----------b---------z+-", /* 11/8 */
    "--e-++y++is++--xf++rlm-++-h", /* 11/9 */
    "zt-o--------w-+--0-++-+u-++", /* 11/10 */
    "--+-y--l-+q+-+nj+-c-----+--", /* 11/11 */
    "v+b-ipmz+-+-+s-+-k+0-++w-++", /* 11/12 */
    "yd-+-++-g+-+--r-++-qj--l+f-", /* 11/13 */
    "----m--v----+---+----+q----", /* 11/14 */
    "---------t---------+-------", /* 11/15 */
    "+-kyv++-+q+m+-+o+f+-i+ag+s-", /* 11/16 */
    "t++----+-----+0-bxh+--c+-n+", /* 11/17 */
    "---vgl+-+k++i--------+-----", /* 11/18 */
    "n++m-y-+----++-+--b++uph+tc", /* 11/19 */
    "+ka-u-p-+++j-0++++q-+--oir+", /* 11/20 */
    "---w-v-+----q---+--h-++----", /* 11/21 */
    "-+--------bx-r---+-----+---", /* 11/22 */
    "+-0j-+v-s+-fa-----+--+----+", /* 11/23 */
    "oh+x+-u+nz+-c+++p--k+-++w+e", /* 11/24 */
    "---------------------------", /* 11/25 */
    "+++f-++-tw+-kbc+z--+-g+-p+a", /* 11/26 */
    "+on-+x+r-l-+p+++g+0a+--+eu+", /* 11/27 */
    "-------+h------------+v----", /* 11/28 */
    "----------w+--x-l-----++---", /* 11/29 */
    "+a-++ize++---+j----+dn--t+-", /* 11/30 */
    "-++-qm----l++--w+-+--s+c--b", /* 12/1 */
    "-------++rz----i-+--h---0++", /* 12/2 */
    "++gn-++--a---+f-+-+-qb-s---", /* 12/3 */
    "--z-+---+-i+l--y-+e+-0rt+++", /* 12/4 */
    "----+g+--e--+-+m----o------", /* 12/5 */
    "-----------------z------++y", /* 12/6 */
    "-qj+++is+++d+f--+m+--ek----", /* 12/7 */
    "h+-t---+---o--++---+-pb+x+z", /* 12/8 */
    "+-+-c+--+++--j---ik-+--af-u", /* 12/9 */
    "-s-q--++---pv-h++-++-+t--g-", /* 12/10 */
    "0n++d+xp++r--+++c+-of--+ji+", /* 12/11 */
    "--------m--w+-----v--++----", /* 12/12 */
    "-+-----------qu-+--b+--z-+-", /* 12/13 */
    "e-+-++r+-n+-h+-c-+y--f--+-k", /* 12/14 */
    "-+-b--t-u--+--w+--l++x++-p-", /* 12/15 */
    "+-q-n+-0--a-r+--++-----f--+", /* 12/16 */
    "-+++--c-w--+t-yl-du++-+-+b-", /* 12/17 */
    "+--+hja+y++u-+-vk--n++-d+0+", /* 12/18 */
    "----+-------e-v---w--++----", /* 12/19 */
    "--d+-r-t--u+--l+-+-++-----p", /* 12/20 */
    "--h-+-+++xy-s---+q+-gi-++e-", /* 12/21 */
    "b+-+-o-----+-t+d---+------l", /* 12/22 */
    "rc+h+pj+++vin+e+s++-y++++xw", /* 12/23 */
    "---------------------------", /* 12/24 */
    "---+-----u--------d-+------", /* 12/25 */
    "qx--+-+-vme-++-g+----+n+---", /* 12/26 */
    "-u+----c---+--+z--+l+-s--+o", /* 12/27 */
    "+-e-++fa+y---+--r+-i---n+--", /* 12/28 */
    "sz-+-------v+---d-+--+0-m++", /* 12/29 */
    "-l+co-++gp++-+++-+nu+-hk--r", /* 12/30 */
    "---------------------------", /* 12/31 */
    "---------------------------", /* 1/1 */
    "-+r--w++----xh--b+-g-+++-v-", /* 1/2 */
    "-----z-------------------+-", /* 1/3 */
    "+-a+k-+d+++-g+--n+rx+ji+u--", /* 1/4 */
    "-e-s++p--f0+w-q++-+-z-+-l++", /* 1/5 */
    "--+-----+-----+--o---c-i---", /* 1/6 */
    "++-0b++----m+z-+---fpayg+++", /* 1/7 */
    "+p++ad++-+h+-l++oc+j--g-+ys", /* 1/8 */
    "--------u---+----+--+r-m---", /* 1/9 */
    "-t-------s--------++-------", /* 1/10 */
    "--u---h+m-or+w+x++--++++v-q", /* 1/11 */
    "++-as+k-+b+t-i-f--++-------", /* 1/12 */
    "--w-+--+-0----+-eh--x-++-o+", /* 1/13 */
    "++m+-aq-+-tb+v-++-p+-+--id-", /* 1/14 */
    "k--+++-r-d+0-y+--+oew-+f+-+", /* 1/15 */
    "-+v---b---------+----+---q-", /* 1/16 */
    "+--++--++---+-ar-+edi-m0-h+", /* 1/17 */
    "-j---u+o-+-ny++-----+g--+--", /* 1/18 */
    "+f++z+--a-+s-k-q+++c--+rw+d", /* 1/19 */
    "------+--g--+--+----m--p---", /* 1/20 */
    "++o+l+-nb-d+v++-as+--+z-f+-", /* 1/21 */
    "p-+kwx+0q++---c++-t++u++gj+", /* 1/22 */
    "-------------+---+-r------n", /* 1/23 */
    "-+-h-b-+--+---k---------z+-", /* 1/24 */
    "o-n-j----+-y-++-v++-r+x++-s", /* 1/25 */
    "+++--t-i+-m-+b-+--c+a----p-", /* 1/26 */
    "---e+0+--+g+----yl----j-+-+", /* 1/27 */
    "c-++---mz---+sdv--++t+---+-", /* 1/28 */
    "x---+++g++j+-etliy0+--f++-+", /* 1/29 */
    "-+---------------v--b+-----", /* 1/30 */
    "f---h+-+l--+---------------", /* 1/31 */
    "-r-g--+--z+uxo+-++--+w++q+k", /* 2/1 */
    "+++-tpi++-c---h+-0a+----b-+", /* 2/2 */
    "---z+----+--j-------v+-e-+-", /* 2/3 */
    "+++i-+w++-+-fcsk-a++--+bh-t", /* 2/4 */
    "e-k-+--+--++-++-h--n-zl-o+-", /* 2/5 */
    "---u-g+-0+--+--j++r-+--q-m+", /* 2/6 */
    "+-t----ak-+--+---n-+-------", /* 2/7 */
    "---l+++--o-++-+fe---m+v+-gx", /* 2/8 */
    "s++-q--bc-nwz+-u+t+++y+-++-", /* 2/9 */
    "+--o-+x+rh---a+--+-----+--f", /* 2/10 */
    "---------------------------", /* 2/11 */
    "---------------------------", /* 2/12 */
    "---------------------------", /* 2/13 */
    "---------------------------", /* 2/14 */
    "js--++e+++xm+-p++q+y-fi++-h", /* 2/15 */
    "--++--o--c-+-d+----w+u+--l-", /* 2/16 */
    "i+--++-x+-f--+-0be-----+n-+", /* 2/17 */
    "l-++p-d----+u-c+0-+v+++-sw+", /* 2/18 */
    "-i---+-f++-z-x------j--+-+-", /* 2/19 */
    "gv+rc-+---+-+-+-++om-+--k-q", /* 2/20 */
    "--d+-h-+-----+-+---z+-up-+n", /* 2/21 */
    "-w--+kj-o++v-q+e++---++-r--", /* 2/22 */
    "+g-+0-+-d-s+----t-++-l-za++", /* 2/23 */
    "--+--c---+--w--+-j--p-+----", /* 2/24 */
    "+y-0+-+ke-+++ta-sg++z-lm+++", /* 2/25 */
    "t--++e-+-+d--h+----+-+-v-jo", /* 2/26 */
    "-ms--qv-p--++--++u+-++--l--", /* 2/27 */
    "---+d----z---------------+-", /* 2/28 */
    "+-y----q+++i-o+a+wj+-k+-+-t", /* 3/1 */
    "-+l+b--+---+dp-+-----h-+-x-", /* 3/2 */
    "0---++--+-------r+fei-----+", /* 3/3 */
    "-+-+--+---+xb--uk-g-+d-+---", /* 3/4 */
    "+-i--+-o++aj0++----n--y-+f+", /* 3/5 */
    "---e+-+--------g+-xq+-++wu-", /* 3/6 */
    "-n-----+v---o++--h---+-----", /* 3/7 */
    "d-++++s-yx-f---z--+-c-e+++-", /* 3/8 */
    "+-----n+--o--+++hat+0+p--v+", /* 3/9 */
    "-----m--++--+--------i--j--", /* 3/10 */
    "++pahl0+--q+-++++b+sn-o+x-+", /* 3/11 */
    "h-q+r--+-++---k-++----dj---", /* 3/12 */
    "-+---+--lf-+pb-+--+0sy--+-+", /* 3/13 */
    "-c+---+w----z---------+g-+-", /* 3/14 */
    "---++--y++r+-+n+-+dpej--+li", /* 3/15 */
    "c++b-s----+-+---w-+-kx++--m", /* 3/16 */
    "-----nl-j+-+-+r+-+------p--", /* 3/17 */
    "k-++s-+u--+-+--tm-++++g-dcv", /* 3/18 */
    "-r--n+-jf++--+--u+--+-x+-k-", /* 3/19 */
    "b++p--+----++-++--mo-l--c-g", /* 3/20 */
    "+--------+--+m-----------aj", /* 3/21 */
    "--+r+-+-+peq-ug+++ic+w+y+--", /* 3/22 */
    "+-atk+-+--+hf-----z+-----+-", /* 3/23 */
    "-0----+-++--jgi+-p--y-+w+-+", /* 3/24 */
    "+-hqtu-+--+a--z-+k-+++v--+-", /* 3/25 */
    "+-++-g+-++dc-a-y0------i+j+", /* 3/26 */
    "-+--+--e-u--+-m--s+b++-v---", /* 3/27 */
    "------y---+k------------+--", /* 3/28 */
    "+or+++-nzw-e+++ma++d-++fv+s", /* 3/29 */
    "-+------+ib--q--+----------", /* 3/30 */
    "w---x------+y-+-----lo+++--", /* 3/31 */
    "u+f+-+-d+mn-++-i+-q++t----b", /* 4/1 */
    "--x-f+z-y-+--r0w-+k---+++++", /* 4/2 */
    "mt-h--u+-l-++---+--++q-----", /* 4/3 */
    "---------------------------", /* 4/4 */
    "-qe++w+kx-+g-+s-+n+-v++++yd", /* 4/5 */
    "+a+-------cp+0t+---++-mu--+", /* 4/6 */
    "q---rz+-j+------++------g+-", /* 4/7 */
    "-++k0yms--+-+--bct++w-+-+-+", /* 4/8 */
    "+-t+----p+-zv+d+--n+-+-j-+a", /* 4/9 */
    "-h----++-g------+q--y---+--", /* 4/10 */
    "-k+--i--+-+w-c-x-+r---++---", /* 4/11 */
    "---++v++m+-++-ejd--hg+z-l+-", /* 4/12 */
    "++-na-xb--t-u++-o--++--+---", /* 4/13 */
    "--s-----++-y-----0+--ijz+++", /* 4/14 */
    "o++c++fq--p-+e++++b--m----r", /* 4/15 */
    "+---o+--+y-+l-+----ax-f++i-", /* 4/16 */
    "-0+s--p+-vh--+-+nc+--+----+", /* 4/17 */
    "d--+-+--l--+--------f------", /* 4/18 */
    "r+----++-x0-g+bnt+h++-++uw+", /* 4/19 */
    "--+-k-lo--+++-+s--+-----m-c", /* 4/20 */
    "n+b--j--++---+---+-r-zi--+-", /* 4/21 */
    "-d-++++--f+u--++-o-k+p-y+ge", /* 4/22 */
    "+-+----c+-+-ikq-+-a-+-u----", /* 4/23 */
    "-e0+++jtw+-++--fsd++-++lvm+", /* 4/24 */
};
