// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +fp8dot4 -target-feature +sme -target-feature +sve -target-feature +sve2 -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +ssve-fp8dot4 -target-feature +sve -verify=streaming-guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +fp8dot4 -target-feature +sme -target-feature +ssve-fp8dot4 -target-feature +sve -target-feature +sve2 -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve2,fp8dot4" streaming_guard="sme,ssve-fp8dot4" flags="feature-dependent"

void test(void) {
  fpm_t fpm_t_val;
  mfloat8_t mfloat8_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
}

void test_streaming(void) __arm_streaming{
  fpm_t fpm_t_val;
  mfloat8_t mfloat8_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svdot_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svdot_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svdot_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svdot_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svdot_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svdot_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  fpm_t fpm_t_val;
  mfloat8_t mfloat8_t_val;
  svfloat32_t svfloat32_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_lane_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_lane_fpm(svfloat32_t_val, svmfloat8_t_val, svmfloat8_t_val, 2, fpm_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svdot_n_f32_mf8_fpm(svfloat32_t_val, svmfloat8_t_val, mfloat8_t_val, fpm_t_val);
}
