# Security Policy

The bstring project is committed to shipping a resilient and memory safe library.
We take any potential security vulnerabilities very seriously.

## Supported Versions

The table below indicate versions of this library that are guaranteed to get security patches.

| Version | Supported |
| ------- | --------- |
| 1.0.x   | ✓         |

We recommend always using the latest stable version to ensure you have the most recent security improvements and bug fixes.

## Reporting a Vulnerability

If you find an exploitable security vulnerability in this software, we would love to hear from you.
Please file a [private GitHub security vulnerability ticket](https://github.com/msteinert/bstring/security/advisories/new).

When reporting a vulnerability, please include as much of the following information as possible:

- Description: A clear description of the vulnerability
- Impact: Potential impact and attack scenarios
- Reproduction: Step-by-step instructions to reproduce the issue
- Affected Versions: Which versions are affected
- Environment: Operating system, software versions, configuration details
- Proof of Concept: A trivial implementation, unit test, or similar
