# Maintainer tools

Useful tools for mdadm maintenance:
- [checkpatch](https://docs.kernel.org/dev-tools/checkpatch.html)
- [kup](https://korg.docs.kernel.org/kup.html)
- [Auto-publishing](https://korg.docs.kernel.org/kup.html#auto-publishing-with-git-archive-signer)
- [b4](https://b4.docs.kernel.org/en/latest/)

# Making a release

Assuming that maintainer is certain that release is safe, following steps must be done:

- Make and push release commit:
  - Update versions strings, refer to previous releases for examples.
  - Update CHANGELOG.md.

- Create GPG signed tag and push it to both remotes. Use same format as was used previously,
  prefixed by **mdadm-**, e.g. **mdadm-3.1.2**, **mdadm-4.1**.

- Run kernel.org
  [Auto-publishing](https://korg.docs.kernel.org/kup.html#auto-publishing-with-git-archive-signer):

  Adopt script to our release tag model. When ready, push signed note to kernel.org repository. If
  it is done correctly, then *(sig)* is added to the package automatically generated by
  kernel.org automation. There is no need to upload archive manually.

- Add release entry on Github.

- Write "ANNOUNCE" mail to linux-raid@kernel.org to notify community.
