#!/usr/bin/perl

#####################################################################
# Program: virtualpasswd.pl
# Purpose: Update a VPOP3d password file with an encrypted password
# Author : Taken from the GNU-pop3d patch web site
#
# Syntax : virtualpasswd.pl <UserName> <password> >> <password_file>
#####################################################################

 if (@ARGV < 2) {
   print "Syntax: VirtualPasswd.pl <username> <password>\n";
   exit 1;
 }

 $name = $ARGV[0];

 @salt_chars         = ('a'..'z','A'..'Z','0'..'9');
 $salt               = $salt_chars[rand(62)] . $salt_chars[rand(62)];

 $passwd = crypt ($ARGV[1], $salt);

 print "$name:$passwd\n";

exit;
