local a = LN(SymbolExpression("x"))
local b = LN(BinaryOperation.POWEXP({E, SymbolExpression("x")}))
local c = BinaryOperation.POWEXP({Integer(2), LOG(Integer(2), SymbolExpression("y"))})
local d = dparse("e^(-x*ln(x))")

local e = Logarithm(Integer(2), Integer(256))
local f = Logarithm(Integer(4), Integer(8))
local g = Logarithm(Integer(1)/Integer(5), Integer((125)))
local h = Logarithm(Integer(1)/Integer(9), Integer(1)/Integer(243))
local i = Logarithm(Integer(1)/Integer(25), Integer(3125))

local k = Logarithm(E, Integer(1)/Integer(9))

starttest("logarithms")
testeq(a, "log(e, x)")
testeq(a:autosimplify(), "log(e, x)", a)
testeq(b:autosimplify(), "x", b)
testeq(c:autosimplify(), "y", c)
testeq(d:autosimplify(), parse("x^(-x)"), d)
testeq(e:autosimplify(), parse("8"), e)
testeq(f:autosimplify(), parse("3/2"), f)
testeq(g:autosimplify(), parse("-3"), g)
testeq(h:autosimplify(), parse("5/2"), h)
testeq(i:autosimplify(), parse("-5/2"), i)
testeq(k:autosimplify(), parse("-ln(9)"), k)
endtest()