/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class RMIClassLoader {
    private static Map cacheLoaders = new Hashtable(89);
    private static Map cacheAnnotations = new Hashtable(89);
    private static String defaultAnnotation = System.getProperty("java.rmi.server.defaultAnnotation");
    private static URL defaultCodebase;
    private static MyClassLoader defaultLoader;

    public static Class loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass("", name);
    }

    public static Class loadClass(String codebases, String name) throws MalformedURLException, ClassNotFoundException {
        Class c = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            c = loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (c != null) {
            return c;
        }
        if (codebases.length() == 0) {
            loader = defaultLoader;
        } else {
            loader = (ClassLoader)cacheLoaders.get(codebases);
            if (loader == null) {
                StringTokenizer tok = new StringTokenizer(codebases, " ");
                ArrayList urls = new ArrayList();
                while (tok.hasMoreTokens()) {
                    urls.add(new URL(tok.nextToken()));
                }
                loader = new MyClassLoader((URL[])urls.toArray(new URL[urls.size()]), null, codebases);
                cacheLoaders.put(codebases, loader);
            }
        }
        return loader.loadClass(name);
    }

    public static String getClassAnnotation(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        if (loader == null || loader == ClassLoader.getSystemClassLoader()) {
            return null;
        }
        if (loader instanceof MyClassLoader) {
            return ((MyClassLoader)loader).getClassAnnotation();
        }
        String s = (String)cacheAnnotations.get(loader);
        if (s != null) {
            return s;
        }
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            for (int i = 0; i < urls.length; ++i) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
            }
            s = annotation.toString();
            cacheAnnotations.put(loader, s);
        }
        return null;
    }

    public static Object getSecurityContext(ClassLoader loader) {
        throw new Error("Not implemented");
    }

    static {
        try {
            if (defaultAnnotation != null) {
                defaultCodebase = new URL(defaultAnnotation);
            }
        }
        catch (Exception _) {
            defaultCodebase = null;
        }
        if (defaultCodebase != null) {
            defaultLoader = new MyClassLoader(new URL[]{defaultCodebase}, null, defaultAnnotation);
            cacheLoaders.put(defaultAnnotation, defaultLoader);
        }
    }

    private static class MyClassLoader
    extends URLClassLoader {
        private final String annotation;

        private MyClassLoader(URL[] urls, ClassLoader parent, String annotation) {
            super(urls, parent);
            this.annotation = annotation;
        }

        private MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.annotation = MyClassLoader.urlToAnnotation(urls);
        }

        public static String urlToAnnotation(URL[] urls) {
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            for (int i = 0; i < urls.length; ++i) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
            }
            return annotation.toString();
        }

        public final String getClassAnnotation() {
            return this.annotation;
        }
    }
}

