/*
  ImageMagick Hash Methods
*/
#ifndef _MAGICK_HASH_H
#define _MAGICK_HASH_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#define SmallHashMapSize  17
#define MediumHashMapSize  701
#define LargeHashMapSize  8191

typedef struct _HashMapInfo
  HashMapInfo;

typedef struct _LinkedListInfo
  LinkedListInfo;

/*
  Method declarations.
*/
extern MagickExport LinkedListInfo
  *AcquireLinkedList(const size_t);

extern MagickExport HashMapInfo
  *AcquireHashMap(const size_t,size_t (*)(const void *),void (*)(void **),
    void (*)(void **));

extern MagickExport size_t
  GetNumberOfElementsInLinkedList(const LinkedListInfo *),
  GetNumberOfEntriesInHashMap(const HashMapInfo *),
  HashPointerType(const void *),
  HashStringType(const void *);

extern MagickExport unsigned int
  AppendElementToLinkedList(LinkedListInfo *,void *),
  InsertElementInLinkedList(LinkedListInfo *,size_t,void *),
  InsertElementInSortedLinkedList(LinkedListInfo *,
    int (*)(const void *,const void *),void **,void *),
  IsHashMapEmpty(HashMapInfo *),
  IsLinkedListEmpty(const LinkedListInfo *),
  LinkedListToArray(LinkedListInfo *,void **),
  PutEntryInHashMap(HashMapInfo *,void *,void *);

extern MagickExport void
  ClearLinkedList(LinkedListInfo *,void (*)(void **)),
  DestroyHashMap(HashMapInfo *),
  DestroyLinkedList(LinkedListInfo *,void (*)(void **)),
  *GetElementFromLinkedList(const LinkedListInfo*,size_t),
  *GetEntryFromHashMap(const HashMapInfo *,const void *),
  *GetLastElementInLinkedList(const LinkedListInfo*),
  *GetNextElementInLinkedList(LinkedListInfo *),
  *GetNextEntryInHashMap(HashMapInfo *),
  *RemoveElementByValueFromLinkedList(LinkedListInfo *,void *),
  *RemoveElementFromLinkedList(LinkedListInfo *,size_t),
  *RemoveEntryFromHashMap(HashMapInfo *,const void *),
  *RemoveLastElementFromLinkedList(LinkedListInfo *),
  ResetHashMapIterator(HashMapInfo *),
  ResetLinkedListIterator(LinkedListInfo *);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
