/* AbiWord
 * Copyright (C) 2001 AbiSource, Inc.
 * Copyright (C) 2002-2003 Marc Maurer (j.m.maurer@student.utwente.nl)
 * Copyright (C) 2001-2003 William Lachance (william.lachance@sympatico.ca)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

/* See bug 1764
 * This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef IE_IMP_WP_H
#define IE_IMP_WP_H

#include <stdio.h>
#include <libwpd/libwpd.h>
#include "ie_imp.h"
#include "ut_string.h"
#include "ut_string_class.h"
#include "ut_growbuf.h"
#include "ut_mbtowc.h"
#include "ut_hash.h"
#include "pd_Document.h"
#include "fl_AutoNum.h"
#include "fl_TableLayout.h"

// The importer/reader for WordPerfect 6 documents.

#define WP_WORDPERFECT6789_EXPECTED_MAJOR_VERSION 2
#define WP_WORDPERFECT_DOCUMENT_FILE_TYPE 10

#define WP_HEADER_PRODUCT_TYPE_OFFSET 8
#define WP_HEADER_FILE_TYPE_OFFSET 9
#define WP_HEADER_MAJOR_VERSION_OFFSET 10
#define WP_HEADER_MINOR_VERSION_OFFSET 11

#define WP6_NUM_LIST_LEVELS 8  // see WP6FileStructure.h

// These are the defaults for generating list text
#define WP_PARAGRAPH_STYLE_MARGIN_LEFT_INCREMENT 0.5f // I have no idea if this is correct, but it seems to look reasonably good
#define WP_PARAGRAPH_STYLE_TEXT_INDENT_DECREMENT -0.3f // I have no idea if this is correct, but it seems to look reasonably good

// ABI_ListDefinition: tracks information on the list
class ABI_ListDefinition
{
public:
    ABI_ListDefinition(int iOutlineHash);
    void setListID(const int iLevel, const UT_uint32 iID) { m_iListIDs[iLevel-1] = iID; }
    const UT_uint32 getListID(const int iLevel) const { return m_iListIDs[iLevel-1]; }
    const List_Type getListType(const int iLevel) const { return m_listTypes[iLevel-1]; }
    void setListType(const int iLevel, const WPXNumberingType type);
    void incrementLevelNumber(const int iLevel) { m_iListNumbers[iLevel - 1]++; }
    void setLevelNumber(const int iLevel, const int iNumber) { m_iListNumbers[iLevel - 1] = iNumber; }
    const int getLevelNumber(const int iLevel) const { return m_iListNumbers[iLevel - 1]; }
    const int getOutlineHash() const { return m_iOutlineHash; }

private:
    //int m_iWPOutlineHash; // we don't use this information in AbiWord, only for id purposes during filtering
    UT_uint32 m_iListIDs[WP6_NUM_LIST_LEVELS];
    int m_iListNumbers[WP6_NUM_LIST_LEVELS];
    List_Type m_listTypes[WP6_NUM_LIST_LEVELS];
    int m_iOutlineHash;
};

class ABI_List
{
};

class ABI_EXPORT IE_Imp_WordPerfect_Sniffer : public IE_ImpSniffer
{
    friend class IE_Imp;
    friend class IE_Imp_WordPerfect;
    
public:
    IE_Imp_WordPerfect_Sniffer();
    virtual ~IE_Imp_WordPerfect_Sniffer();
    
    virtual UT_Confidence_t recognizeContents (const char * szBuf,
					       UT_uint32 iNumbytes);
    virtual UT_Confidence_t recognizeSuffix (const char * szSuffix);
    virtual bool getDlgLabels (const char ** szDesc,
			       const char ** szSuffixList,
			       IEFileType * ft);
    virtual UT_Error constructImporter (PD_Document * pDocument,
					IE_Imp ** ppie);
};

class ABI_EXPORT IE_Imp_WordPerfect : public IE_Imp, public WPXHLListenerImpl
{
public:
    IE_Imp_WordPerfect(PD_Document * pDocument);
    ~IE_Imp_WordPerfect();
    
    virtual UT_Error importFile(const char * szFilename);
    virtual void pasteFromBuffer(PD_DocumentRange * pDocRange,
				 UT_uint8 * pData, UT_uint32 lenData, const char * szEncoding = 0);
    
    virtual void setDocumentMetaData(const UCSString &author, const UCSString &subject,
				     const UCSString &publisher, const UCSString &category,
				     const UCSString &keywords, const UCSString &language,
				     const UCSString &abstract, const UCSString &descriptiveName,
				     const UCSString &descriptiveType);

    virtual void startDocument();
    virtual void endDocument();

	virtual void openPageSpan(const int span, const bool isLastPageSpan,
				  const float marginLeft, const float marginRight,
				  const float marginTop, const float marginBottom);
	virtual void openHeaderFooter(const WPXHeaderFooterType headerFooterType, 
				  const WPXHeaderFooterOccurence headerFooterOccurence) { /* TODO: IMPLEMENT ME*/ };
	virtual void closeHeaderFooter(const WPXHeaderFooterType headerFooterType, 
				  const WPXHeaderFooterOccurence headerFooterOccurence) { /* TODO: IMPLEMENT ME*/ };
	
	virtual void openParagraph(const guint8 paragraphJustification, const guint32 textAttributeBits,
				   const float marginLeftOffset, const float marginRightOffset,
				   const gchar *fontName, const float fontSize, 
				   const float lineSpacing, 
				   const bool isColumnBreak, const bool isPageBreak);				  
	virtual void closeParagraph() {};
    virtual void openSpan(const guint32 textAttributeBits, const gchar *fontName, const float fontSize);
	virtual void closeSpan() {};		
	virtual void openSection(const guint numColumns);
	virtual void closeSection() {};	
		
	virtual void insertTab();
    virtual void insertText(const UCSString &text);
    virtual void insertLineBreak();
    
    virtual void defineOrderedListLevel(const int listID, const guint16 listLevel, const WPXNumberingType listType, 
					const UCSString &textBeforeNumber, const UCSString &textAfterNumber,
					const int startingNumber);
    virtual void defineUnorderedListLevel(const int listID, const guint16 listLevel, const UCSString &bullet);
    virtual void openOrderedListLevel(const int listID);
    virtual void openUnorderedListLevel(const int listID) { m_iCurrentListLevel++; }
    virtual void closeOrderedListLevel(); 
    virtual void closeUnorderedListLevel() { m_iCurrentListLevel--; }
	virtual void openListElement(const guint8 paragraphJustification, const guint32 textAttributeBits,
				     const float marginLeftOffset, const float marginRightOffset,
				     const gchar *fontName, const float fontSize, 
				     const float lineSpacing) { /* TODO: IMPLEMENT ME*/ }	
    virtual void openListElement(const guint8 paragraphJustification, const guint32 textAttributeBits,
							     const gchar *fontName, const float fontSize, 
							     const float lineSpacing);
    virtual void closeListElement() {}

	virtual void openFootnote(int number);
	virtual void closeFootnote();
	virtual void openEndnote(int number);
	virtual void closeEndnote();
		
 	virtual void openTable(const guint8 tablePositionBits, 
			       const float marginLeftOffset, const float marginRightOffset,
			       const float leftOffset, const vector < WPXColumnDefinition > &columns);
	virtual void openTableRow();
	virtual void closeTableRow() {};		
    virtual void openTableCell(const guint32 col, const guint32 row, const guint32 colSpan, const guint32 rowSpan,
							const guint8 borderBits,
							const RGBSColor * cellFgColor, const RGBSColor * cellBgColor);
	virtual void closeTableCell() {};		
    virtual void closeTable();
    
protected:
    UT_Error							_appendSpan(const guint32 textAttributeBits, const gchar *fontName, const float fontSize, UT_uint32 listTag = 0);
    UT_Error                                                    _appendListSpan(UT_uint32 listTag);
    UT_Error							_appendParagraph(const guint8 paragraphJustification, const guint32 textAttributeBits,
										 const gchar *fontName, const float fontSize, const float lineSpacing);
    UT_Error							_appendSection(guint numColumns, const float, const float);
    UT_Error							_updateDocumentOrderedListDefinition(ABI_ListDefinition *pListDefinition, 
												     int iLevel, const WPXNumberingType listType, 
												     const UCSString &sTextBeforeNumber, 
												     const UCSString &sTextAfterNumber,
												     int iStartingNumber);    
    UT_Error							_updateDocumentUnorderedListDefinition(ABI_ListDefinition *pListDefinition, 
												       int level);    
    
private:
    // section props
    float								m_leftMargin;
    float								m_rightMargin;
    UT_uint8							m_numColumns;

	// paragraph props
    float								m_leftMarginOffset;
    float								m_rightMarginOffset;

    // state handling that libwpd can't account for
    //UT_StringPtrMap						m_listStylesHash;
    ABI_ListDefinition *				m_pCurrentListDefinition;
    bool								m_bParagraphChanged;
    bool								m_bParagraphInSection;
    bool								m_bInSection;
    bool								m_bSectionChanged;

    int							        m_iCurrentListLevel;
    bool								m_bInCell;
};
#endif /* IE_IMP_WP_H */
