/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmobjectlink.h"
#include "pmdeclare.h"
#include "pmpart.h"
#include "pmsymboltable.h"
#include "pmobjectlinkedit.h"
#include "pmparser.h"

#include "pmmemento.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>


PMObjectLink::PMObjectLink( )
      : Base( )
{
   m_pLinkedObject = 0;
}

PMObjectLink::~PMObjectLink( )
{
}

QString PMObjectLink::description( ) const
{
   return i18n( "object link" );
}

bool PMObjectLink::isA( PMObjectType t ) const
{
   if( t == PMTObjectLink )
      return true;
   return Base::isA( t );
}

bool PMObjectLink::setLinkedObject( PMDeclare* obj )
{
   if( obj )
   {
      if( obj->declareType( ) == PMDeclare::ObjectDeclare )
      {
         if( m_pLinkedObject != obj )
         {
            if( m_pMemento )
            {
               m_pMemento->addData( PMTObjectLink, PMLinkedObjectID,
                                    m_pLinkedObject );
               m_pMemento->setViewStructureChanged( );
            }
            
            if( m_pLinkedObject )
            {
               m_pLinkedObject->removeLinkedObject( this );
               if( m_pMemento )
                  m_pMemento->addChangedObject( m_pLinkedObject, PMCData );
            }
            m_pLinkedObject = obj;
            m_pLinkedObject->addLinkedObject( this );
            if( m_pMemento )
               m_pMemento->addChangedObject( m_pLinkedObject, PMCData );
         }
         return true;
      }
      else
         return false;
   }
   else
   {
      if( m_pLinkedObject != 0 )
      {
         if( m_pMemento )
         {
            m_pMemento->addData( PMTObjectLink, PMLinkedObjectID,
                                 m_pLinkedObject );
            m_pMemento->addChangedObject( m_pLinkedObject, PMCData );
         }
         m_pLinkedObject->removeLinkedObject( this );
         m_pLinkedObject = 0;
      }
      return true;
   }
   return false;
}

void PMObjectLink::serialize( PMOutputDevice& dev ) const
{
   bool writeComment = true;
   if( m_pLinkedObject)
   {
      if( m_pLinkedObject->firstChild( ) )
      {
         dev.objectBegin( "object" );
         
         serializeName( dev );
         dev.writeLine( m_pLinkedObject->id( ) );
         Base::serialize( dev );
         writeComment = false;
         
         dev.objectEnd( );
      }
   }
   if( writeComment )
   {
      QString text;
      text = name( );
      if( text.isEmpty( ) )
         text = description( );
      
      dev.writeComment( QString( "No prototype for %1" ).arg( text ) );
   }
}

void PMObjectLink::serialize( QDomElement& e, QDomDocument& doc ) const
{
   if( m_pLinkedObject )
      e.setAttribute( "prototype", m_pLinkedObject->id( ) );
   Base::serialize( e, doc );
}

void PMObjectLink::readAttributes( const PMXMLHelper& h )
{
   QString id = h.stringAttribute( "prototype", "" );
   if( !id.isEmpty( ) )
   {
      PMDeclare* link = h.parser( )->checkLink( id );
      if( link )
      {
         if( link->type( ) == PMTDeclare )
         {
            m_pLinkedObject = ( PMDeclare* ) link;
            m_pLinkedObject->addLinkedObject( this );
         }
         else
            h.parser( )->printError( i18n( "Declare \"%1\" has wrong type." )
                                     .arg( id ) );
      }
   }
   Base::readAttributes( h );
}

PMDialogEditBase* PMObjectLink::editWidget( QWidget* parent ) const
{
   return new PMObjectLinkEdit( parent );
}

void PMObjectLink::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTObjectLink )
      {
         switch( data->valueID( ) )
         {
            case PMLinkedObjectID:
               setLinkedObject( ( PMDeclare* ) data->objectData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMObjectLink::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
