/***************************************************************************
                            KDialogBase.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIALOGBASE_H
#define KDIALOGBASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialog.h>

/**

 Provides basic functionality needed by nearly all dialogs.

 It offers the standard action buttons you'd expect to find in a
 dialog as well as the capability to define at most three configurable
 buttons. You can define a main widget that contains your specific
 dialog layout or you can use a predefined layout. Currently, @p
 TreeList/Paged, @p Tabbed, @p Plain, @p Swallow and @p IconList
 mode layouts (faces) are available.

 The class takes care of the geometry management. You only need to define
 a minimum size for the widget you want to use as the main widget.

 You can set a background tile (pixmap) for parts of the dialog. The
 tile you select is shared by all instances of this class in your
 application so that they all get the same look and feel.

 There is a tutorial available on http://developer.kde.org/ (NOT YET)
 that contains
 copy/paste examples as well a screenshots on how to use this class.

 You select which buttons should be displayed, but you do not choose the
 order in which they are displayed. This ensures a standard interface in
 KDE. The button order can be changed, but this ability is only available
 for a central KDE control tool. The following buttons are available:
 OK, Cancel/Close, Apply/Try, Default, Help and three user definable
 buttons: User1, User1 and User3. You must specify the text of the UserN
 buttons. Each button has a virtual slot so you can overload the method
 when required. The default slots emit a signal as well, so you can choose
 to connect a signal instead of overriding the slot.
 The default implementation of @ref -slotHelp will automatically enable
 the help system if you have provided a path to the help text.
 @ref -slotCancel and @ref -slotClose will run @ref -[QDialog reject]
 while @ref -slotOk will run @ref -[QDialog accept]. You define a default
 button in the constructor.

 If you don't want any buttons at all because your dialog is special
 in some way, then set the buttonMask argument in the constructor to zero
 (0). The optional button box separator line should not be enabled
 in this case. Note that the KDialogBase will animate a button press
 when the user press Escape. The button that is enabled is either Cancel,
 Close or the button that is defined by @ref -setEscapeButton The
 animation will not take place when the buttonMask is zero. Your
 custom dialog code should reimplement the @ref keyPressEvent and
 animate the cancel button so that the dialog behaves like regular
 dialogs. NOTE: None of the regular slots (like @ref -slotOk ) or
 signals that are related to the standard action buttons will be used
 when you don't use these buttons.

 You can either use one of the prebuilt, easy to use, faces or
 define your own main widget. The dialog provides ready to use
 TreeList, Tabbed, Plain, Swallow and IconList faces. KDialogBase uses
 the @ref KJanusWidget class internally to accomplish this. If you
 use TreeList, Tabbed or IconList mode, then add pages with @ref -addPage.

 Pages that have been added can be removed again by simply deleting 
 the page.

 If you want complete control of how the dialog contents should look,
 then you can define a main widget by using @ref -setMainWidget. You
 only need to set the minimum size of that widget and the dialog will
 resize itself to fit this minimum size.  The dialog is resizeable, but
 cannot be made smaller than its minimum size.

 The dialog consists of a help area on top (becomes visible if you define
 a help path and use @ref -enableLinkedHelp), the main area which is
 the built-in dialog face or your own widget in the middle and by default
 a button box at the bottom. The button box can also be placed at the
 right edge (to the right of the main widget). Use
 @ref -setButtonBoxOrientation to control this behavior. A separator
 can be placed above the button box (or to the left when the button box
 is at the right edge). Normally you specify that you want a separator
 in the constructor, but you can use @ref -enableButtonSeparator as well.

 The class is derived from @ref KDialog, so you get automatic access to
 the @ref -[KDialog marginHint], @ref -[KDialog spacingHint] and the
 extended @ref -[KDialog setCaption] method. NOTE: The main widget you
 use will be positioned inside the dialog using a margin (or border)
 equal to @ref -[KDialog marginHint]. You shall not add a margin yourself.
 The example below (from kedit) shows how you use the top level widget
 and its layout. The second argument (the border) to @ref QVBoxLayout
 is 0. This situation is valid for @ref addPage , @ref addVBoxPage ,
 @ref addHBoxPage , @ref addGridPage , @ref makeMainWidget ,
 @ref makeVBoxMainWidget , @ref makeHBoxMainWidget and
 @ref makeGridMainWidget as well.

 Example:

 <pre>
 -[UrlDlg UrlDlg]( QWidget *parent, const QString& caption,
                 const QString& urltext)
   : KDialogBase( parent, "urldialog", true, caption, Ok|Cancel, Ok, true )
 {
   QWidget *page = new QWidget( this );
   setMainWidget(page);
   QVBoxLayout *topLayout = new QVBoxLayout( page, 0, -spacingHint );

   QLabel *label = new QLabel( caption, page, "caption" );
   -[topLayout addWidget]( label );

   lineedit = new QLineEdit( urltext, page, "lineedit" );
   -[lineedit setMinimumWidth](-fontMetrics.-maxWidth*20);
   -[topLayout addWidget]( lineedit );

   -[topLayout addStretch];
 }
 </pre>

 If you use @ref -makeVBoxMainWidget, then the dialog above can be made
 simpler but you lose the ability to add a stretchable area:

 <pre>
 -[UrlDlg UrlDlg]( QWidget *parent, const QString& caption,
		const QString& urltext)
 : KDialogBase( parent, "urldialog", true, caption, Ok|Cancel, Ok, true )
 {
   QVBox *page = -makeVBoxMainWidget;
   QLabel *label = new QLabel( caption, page, "caption" );

   lineedit = new QLineEdit( urltext, page, "lineedit" );
   -[lineedit setMinimumWidth](-fontMetrics.-maxWidth*20);
 }
 </pre>

 This class can be used in many ways. Note that most KDE ui widgets
 and many of KDE core applications use the KDialogBase so for more
 inspiration you should study the code for these.

 @author Mirko Boehm (mirko@kde.org) and Espen Sand (espen@kde.org)
 
 @short A dialog base class with standard buttons and predefined layouts.

*/
@class QFrame; 
@class QGrid; 
@class QHBox; 
@class QPushButton; 
@class QVBox;
@class QPixmap;

@class KGuiItem; 

@interface KDialogBase : KDialog 

/** 
 Constructor for the standard mode where you must specify the main
 widget with @ref -setMainWidget .

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal caption: (NSString *)caption buttonMask: (int)buttonMask defaultButton: (int)defaultButton separator: (BOOL)separator user1: (KGuiItem*)user1 user2: (KGuiItem*)user2 user3: (KGuiItem*)user3;
- init;

/** 
 Constructor for the predefined layout mode where you specify the
 kind of layout (face).

*/
- initWithInt: (int)dialogFace caption: (NSString *)caption buttonMask: (int)buttonMask defaultButton: (int)defaultButton parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal separator: (BOOL)separator user1: (KGuiItem*)user1 user2: (KGuiItem*)user2 user3: (KGuiItem*)user3;
- initWithInt: (int)dialogFace caption: (NSString *)caption buttonMask: (int)buttonMask defaultButton: (int)defaultButton ;

/** 
 Constructor for a message box mode where the @p buttonMask can only
 contain Yes, No, or Cancel.

 If you need other names you can rename
 the buttons with @ref -setButtonText. The dialog box is not resizable
 by default but this can be changed by @ref -setInitialSize. If you
 select 'modal' to be true, the dialog will return Yes, No, or Cancel
 when closed otherwise you can use the signals @ref -yesClicked,
 @ref -noClicked, or @ref -cancelClicked to determine the state.

*/
- initWithText: (NSString *)caption buttonMask: (int)buttonMask defaultButton: (int)defaultButton escapeButton: (int)escapeButton parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal separator: (BOOL)separator yes: (KGuiItem*)yes no: (KGuiItem*)no cancel: (KGuiItem*)cancel;
- initWithText: (NSString *)caption ;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 Destruct the Dialog delayed.

 You can call this function from
 slots like @ref -closeClicked and @ref -hidden.
 You should not use the dialog any more after
 calling this function.
     
*/
- delayedDestruct;

/** 
 Sets the orientation of the button box.

 It can be @p Vertical or @p Horizontal. If @p Horizontal
 (default), the button box is positioned at the bottom of the
 dialog. If @p Vertical it will be placed at the right edge of the
 dialog.

*/
- setButtonBoxOrientation: (int)orientation;

/** 
 Sets the button that will be activated when the Escape key
 is pressed.

 Normally you should not use this function. By default,
 the Escape key is mapped to either the Cancel or the Close button
 if one of these buttons are defined. The user expects that Escape will
 cancel an operation so use this function with caution.

*/
- setEscapeButton: (int)identifier;

/** 
 Adjust the size of the dialog to fit the contents just before
 @ref -[QDialog exec] or @ref -[QDialog show] is called.

 This method will not be called if the dialog has been explicitly
 resized before showing it.

*/
- adjustSize;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;

/** 
 Retrieve the empty page when the predefined layout is used in @p Plain
 mode.

 This widget must used as the toplevel widget of your dialog
 code.

*/
- (QFrame*) plainPage;

/** 
 Add a page to the dialog when the class is used in @p TreeList ,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the
 toplevel widget for this particular page.
 Note: The returned frame widget has no
 layout manager associated with it. In order to use it you must
 create a layout yourself as the example below illustrates:

 <pre>
 QFrame *page = addPage( i18n("Layout") );
 QVBoxLayout *topLayout = new QVBoxLayout( page, 0, 6 );
 QLabel *label = new QLabel( i18n("Layout type"), page );
 -[topLayout addWidget]( label );
 ..
 </pre>

*/
- (QFrame*) addPage: (NSString *)item header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QFrame*) addPage: (NSString *)item ;

/** 
 This is like @ref -addPage just above, with the difference that the first
 element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
- (QFrame*) addPageForItems: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QFrame*) addPageForItems: (NSArray *)items ;

/** 
 Add a page to the dialog when the class is used in @p TreeList,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the toplevel widget for
 this particular page. The widget contains a @ref QVBoxLayout
 layout so the widget children are lined up vertically.  You can
 use it as follows:

 <pre>
 QVBox *page = addVBoxPage( i18n("Layout") );
 QLabel *label = new QLabel( i18n("Layout type"), page );
 ..
 </pre>

*/
- (QVBox*) addVBoxPage: (NSString *)itemName header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QVBox*) addVBoxPage: (NSString *)itemName ;

/** 
 This is like @ref -addVBoxPage just above, with the difference
 that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
- (QVBox*) addVBoxPageForItems: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QVBox*) addVBoxPageForItems: (NSArray *)items ;

/** 
 Add a page to the dialog when the class is used in @p TreeList,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the
 toplevel widget for this particular page. The widget contains a
 @ref QHBoxLayout layout so the widget children are lined up horizontally.
 You can use it as follows:

*/
- (QHBox*) addHBoxPage: (NSString *)itemName header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QHBox*) addHBoxPage: (NSString *)itemName ;

/** 
 This is like @ref -addHBoxPage just above, with the
 difference that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
- (QHBox*) addHBoxPageForItems: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QHBox*) addHBoxPageForItems: (NSArray *)items ;

/** 
 Add a page to the dialog when the class is used in @p TreeList,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the
 toplevel widget for this particular page. The widget contains a
 @ref QGridLayout layout so the widget children are  positioned in a grid.

*/
- (QGrid*) addGridPage: (int)n dir: (int)dir itemName: (NSString *)itemName header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QGrid*) addGridPage: (int)n dir: (int)dir itemName: (NSString *)itemName ;

/** 
 This is like @ref -addGridPage just above, with the difference
 that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
- (QGrid*) addGridPage: (int)n dir: (int)dir items: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QGrid*) addGridPage: (int)n dir: (int)dir items: (NSArray *)items ;

/** 
 Sets the icon used in @p TreeList Mode for the given path.

*/
- setFolderIcon: (NSArray *)path pixmap: (QPixmap *)pixmap;

/** 
 Make a main widget.

 The function will make a @ref QFrame widget
 and use @ref -setMainWidget to register it. You can @em not use this
 function more than once, @em not if you have already defined a
 main widget with @ref -setMainWidget and @em not if you have used the
 constructor where you define the face (@p Plain, @p Swallow, @p Tabbed,
 @p TreeList).

*/
- (QFrame*) makeMainWidget;

/** 
 Make a main widget.

 The function will make a @ref QVBox widget
 and use @ref -setMainWidget to register it. You @em can use this
 function more than once, @em not if you have already defined a
 main widget with @ref -setMainWidget and @em not if you have used the
 constructor where you define the face (@p Plain, @p Swallow, @p Tabbed,
 @p TreeList, @p IconList).

*/
- (QVBox*) makeVBoxMainWidget;

/** 
 Make a main widget.

 The function will make a @ref QHBox widget
 and use @ref -setMainWidget to register it. You can @em not use this
 function more than once, @em not if you have already defined a
 main widget with @ref -setMainWidget and @p not if you have used the
 constructor where you define the face (@p Plain, @p Swallow, @p Tabbed,
 @p TreeList, @p IconList).

*/
- (QHBox*) makeHBoxMainWidget;

/** 
 Make a main widget.

 The function will make a @ref QGrid widget
 and use @ref -setMainWidget to register it. You can @em not use this
 function more than once, @em not if you have already defined a
 main widget with @ref  #-setMainWidget and @em not if you have used the
 constructor where you define the face (Plain, Swallow, Tabbed,
 TreeList, IconList).

*/
- (QGrid*) makeGridMainWidget: (int)n dir: (int)dir;

/** 
 Hide or display the a separator line drawn between the action
 buttons an the main widget.
     
*/
- enableButtonSeparator: (BOOL)state;

/** 
 Hide or display a general action button.

  Only buttons that have
 been created in the constructor can be displayed. This method will
 not create a new button.

*/
- showButton: (int)identifier state: (BOOL)state;

/** 
 Hide or display the OK button.

  The OK button must have
 been created in the constructor to be displayed.

*/
- showButtonOK: (BOOL)state;

/** 
 Hide or display the Apply button.

  The Apply button must have
 been created in the constructor to be displayed.

*/
- showButtonApply: (BOOL)state;

/** 
 Hide or display the Cancel button. The Cancel button must have
 been created in the constructor to be displayed.

*/
- showButtonCancel: (BOOL)state;

/** 
 Sets the page with @p index to be displayed.

 This method will only
 work when the dialog is using the predefined shape of TreeList,
 IconList or Tabbed.

*/
- (BOOL) showPage: (int)index;

/** 
 Returns the index of the active page.

 This method will only work when the dialog is using the
 predefined shape of Tabbed, TreeList or IconList.

*/
- (int) activePageIndex;

/** 
 Returns the index of a page created with @ref  #--addPage,
 @ref  #--addVBoxPage, @ref -addHBoxPage or @ref  #--addGridPage.
 You can can compare this index with the value returned from
 @ref  #--activePageIndex if you need to do some page specific actions
 in your code.

 The returned index will never change so you can safely use this
 function once and save the value.

*/
- (int) pageIndex: (QWidget *)widget;

/** 
 Sets the main user definable widget.

 If the dialog is using the predefined Swallow mode, the widget will
 be reparented to the internal swallow control widget. If the dialog
 is being used in the standard mode then the @p widget must have the
 dialog as parent.

*/
- setMainWidget: (QWidget *)widget;

/** 
 Returns the main widget if any.

*/
- (QWidget*) mainWidget;

/** 
 Convenience method.

  Freezes the dialog size using the minimum size
 of the dialog. This method should only be called right before
 @ref -show or @ref -exec.
     
*/
- disableResize;

/** 
 Convenience method. Sets the initial dialog size.

  This method should
 only be called right before @ref -show or @ref -exec. The initial
 size will be
 ignored if smaller than the dialog's minimum size.

*/
- setInitialSize: (QSize *)s noResize: (BOOL)noResize;
- setInitialSize: (QSize *)s ;

/** 
 Convenience method. Add a size to the default minimum size of a
 dialog.

 This method should only be called right before @ref -show or
 @ref -exec.

*/
- incInitialSize: (QSize *)s noResize: (BOOL)noResize;
- incInitialSize: (QSize *)s ;

/** 
 Sets the text of the OK button.

 If the default parameters are used
 (that is, if no parameters are given) the standard texts are set:
 The button shows "OK", the tooltip contains "Accept settings."
 (internationalized) and the quickhelp text explains the standard
 behavior of the OK button in settings dialogs.

*/
- setButtonOKText: (NSString *)text tooltip: (NSString *)tooltip quickhelp: (NSString *)quickhelp;
- setButtonOKText;

/** 
 Sets the text of the Apply button.

 If the default parameters are
 used (that is, if no parameters are given) the standard texts are set:
 The button shows "Apply", the tooltip contains "Apply settings."
 (internationalized) and the quickhelp text explains the standard
 behavior of the apply button in settings dialogs.

*/
- setButtonApplyText: (NSString *)text tooltip: (NSString *)tooltip quickhelp: (NSString *)quickhelp;
- setButtonApplyText;

/** 
 Sets the text of the Cancel button.

  If the default parameters are
 used (that is, if no parameters are given) the standard texts are set:
 The button shows "Cancel", everything else will not be set.

*/
- setButtonCancelText: (NSString *)text tooltip: (NSString *)tooltip quickhelp: (NSString *)quickhelp;
- setButtonCancelText;

/** 
 Sets the text of any button.

*/
- setButtonText: (int)identifier text: (NSString *)text;

/** 
 Sets the tooltip text of any button.

*/
- setButtonTip: (int)identifier text: (NSString *)text;

/** 
 Sets the "What's this?" text of any button.

*/
- setButtonWhatsThis: (int)identifier text: (NSString *)text;

/** 
 This function has only effect in TreeList mode.

 Defines how the tree list widget is resized when the dialog is
 resized horizontally. By default the tree list keeps its width
 when the dialog becomes wider.

*/
- setTreeListAutoResize: (BOOL)state;

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the icons given in the @ref addPage,
 @ref addVBoxPage, @ref addHBoxPage, or @ref addGridPage methods should
 be shown in the TreeList.

 Note: This method must be called before calling any of the methods
 which add icons to the page.

*/
- setShowIconsInTreeList: (BOOL)state;

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the root should be decorated.
 For details see @ref -[QListView setRootIsDecorated]
*/
- setRootIsDecorated: (BOOL)state;

/** 
 This function has only effect in IconList mode.

 Defines how the icon list widget is displayed. By default it is
 the widgets in the dialog pages that decide the minimum height
 of the dialog. A vertical scrollbar can be used in the icon list
 area.

*/
- setIconListAllVisible: (BOOL)state;

/** 
 Enable hiding of the background tile (if any).

*/
- showTile: (BOOL)state;

/** 

 Do not use this method. It is included for compatibility reasons.

 This method returns the border widths in all directions the dialog
 needs for itself. Respect this, or get bad looking results.
 The references are upper left x (@p ulx), upper left y (@p uly),
 lower right x (@p lrx), and lower left y (@p lly).
 The results are differences in pixels from the
 dialogs corners.
     
*/
- getBorderWidths: (int)ulx uly: (int)uly lrx: (int)lrx lry: (int)lry;

/** 

 Do not use this method. It is included for compatibility reasons.

 This method returns the contents rectangle of the work area. Place
 your widgets inside this rectangle, and use it to set up
 their geometry. Be careful: The rectangle is only valid after
 resizing the dialog, as it is a result of the resizing process.
 If you need the "overhead" the dialog needs for its elements,
 use @ref -getBorderWidths.
     
*/
- (QRect*) getContentsRect;

/** 
 Calculate the size hint for the dialog.

 With this method it is easy to calculate a size hint for a
 dialog derived from KDialogBase if you know the width and height of
 the elements you add to the widget. The rectangle returned is
 calculated so that all elements exactly fit into it. Thus, you may
 set it as a minimum size for the resulting dialog.

 You should not need to use this method and never if you use one of
 the predefined shapes.

*/
- (QSize*) calculateSize: (int)w h: (int)h;

/** 
 Returns the help link text.

  If no text has been defined,
 "Get help..." (internationalized) is returned.

*/
- (NSString *) helpLinkText;

/** 
 Returns the action button that corresponds to the @p id.

 Normally
 you should not use this function. @em Never delete the object returned
 by this function. See also @ref -enableButton, @ref -showButton,
 @ref -setButtonTip, @ref -setButtonWhatsThis, and @ref -setButtonText.

     
*/
- (QPushButton*) actionButton: (int)identifier;

/** 
 Enable or disable (gray out) a general action button.

*/
- enableButton: (int)identifier state: (BOOL)state;

/** 
 Enable or disable (gray out) the OK button.

*/
- enableButtonOK: (BOOL)state;

/** 
 Enable or disable (gray out) the Apply button.

*/
- enableButtonApply: (BOOL)state;

/** 
 Enable or disable (gray out) the Cancel button.

*/
- enableButtonCancel: (BOOL)state;

/** 
 Display or hide the help link area on the top of the dialog.

*/
- enableLinkedHelp: (BOOL)state;

/** 
 Sets the text that is shown as the linked text.

 If text is empty,
 the text "Get help..." (internationalized) is used instead.

*/
- setHelpLinkText: (NSString *)text;

/** 
 Sets the help path and topic.

*/
- setHelp: (NSString *)anchor appname: (NSString *)appname;
- setHelp: (NSString *)anchor ;

/** 
 Connected to help link label.
     
*/
- helpClickedSlot: (NSString *)arg1;

/** 
 Sets the status of the Details button.
     
*/
- setDetails: (BOOL)showDetails;

/** 
 Sets the widget that gets shown when "Details" is enabled.

 The dialog takes over ownership of the widget.
 Any previously set widget gets deleted.
     
*/
- setDetailsWidget: (QWidget *)detailsWidget;

/** 
 This method is called automatically whenever the background has
 changed. You do not need to use this method.
     
*/
- updateBackground;

/** 
 Check whether the background tile is set or not.

*/
+ (BOOL) haveBackgroundTile;

/** 
 Returns a pointer to the background tile if there is one.

*/
+ (QPixmap*) backgroundTile;

/** 

 Use @ref -backgroundTile instead.
     
*/
+ (QPixmap*) getBackgroundTile;

/** 
 Sets the background tile.

  If it is Null (0), the background image is deleted.

*/
+ setBackgroundTile: (QPixmap *)pix;

/** 
 Activated when the Help button has been clicked. If a help
 text has been defined, the help system will be activated.
     
*/
- slotHelp;

/** 
 Activated when the Default button has been clicked.
     
*/
- slotDefault;

/** 
 Activated when the Details button has been clicked.

*/
- slotDetails;

/** 
 Activated when the User3 button has been clicked.
     
*/
- slotUser3;

/** 
 Activated when the User2 button has been clicked.
     
*/
- slotUser2;

/** 
 Activated when the User1 button has been clicked.
     
*/
- slotUser1;

/** 
 Activated when the Ok button has been clicked. The
 @ref -[QDialog accept] is activated.
     
*/
- slotOk;

/** 
 Activated when the Apply button has been clicked.
     
*/
- slotApply;

/** 
 Activated when the Try button has been clicked.
     
*/
- slotTry;

/** 
 Activated when the Yes button has been clicked. The
 @ref -[QDialog done]( Yes ) is activated.
     
*/
- slotYes;

/** 
 Activated when the Yes button has been clicked. The
 @ref -[QDialog done]( No ) is activated.
     
*/
- slotNo;

/** 
 Activated when the Cancel button has been clicked. The
 @ref -[QDialog reject] is activated in regular mode and
 @ref -[QDialog done]( Cancel ) when in message box mode.
     
*/
- slotCancel;

/** 
 Activated when the Close button has been clicked. The
 @ref -[QDialog reject] is activated.
     
*/
- slotClose;

/** 
 Do not use this slot. Is is kept for compatibility reasons.
 Activated when the Apply button has been clicked
     
*/
- applyPressed;

/** 
 Updates the margins and spacings.
     
*/
- updateGeometry;

/** 
 Deletes the dialog.
     
*/
- slotDelayedDestruct;
+ (int) Help;
+ (int) Default;
+ (int) Ok;
+ (int) Apply;
+ (int) Try;
+ (int) Cancel;
+ (int) Close;
+ (int) User1;
+ (int) User2;
+ (int) User3;
+ (int) No;
+ (int) Yes;
+ (int) Details;
+ (int) Filler;
+ (int) Stretch;
+ (int) ActionStyle0;
+ (int) ActionStyle1;
+ (int) ActionStyle2;
+ (int) ActionStyle3;
+ (int) ActionStyle4;
+ (int) ActionStyleMAX;
+ (int) TreeList;
+ (int) Tabbed;
+ (int) Plain;
+ (int) Swallow;
+ (int) IconList;
@end

/** Override these methods in subclasses of KDialogBase to customise event handling behaviour */
@protocol KDialogBaseEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
