/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __wizard_h__
#define __wizard_h__

#include <qwidget.h>
#include <qptrlist.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>

class Wizard;
class QuickHelp;
class QPushButton;
class QLabel;
class KAccel;

class Wizard : public QWidget
{
    Q_OBJECT
public:
    Wizard( QWidget *parent, const char *name = 0 );
    virtual ~Wizard();

    QWidget *viewport() const { return m_stack; }

    void appendPage( QWidget *page );

    int numPages() const { return m_pages.count(); }

    QPtrList<QWidget> pages() const { return m_pages; }

    void setActivePage( unsigned int page );

    bool backEnabled() const { return m_back->isEnabled(); }

    void setBackVisible( bool v )
    {
        if (v)
            m_back->show();
        else
            m_back->hide();
    }
    bool backVisible() const { return m_back->isVisible(); }

    bool forwardEnabled() const { return m_forward->isEnabled(); }

    void setForwardVisible( bool v )
    {
        if (v)
            m_forward->show();
        else
            m_forward->hide();
    }
    bool forwardVisible() const { return m_forward->isVisible(); }

    bool finishEnabled() const { return m_finish->isEnabled(); }

    void setFinishVisible( bool v )
    {
        if (v)
            m_finish->show();
        else
            m_finish->hide();
    }
    bool finishVisible() const { return m_finish->isVisible(); }

public slots:
    void setBackEnabled( bool enable );
    void setForwardEnabled( bool enable );
    void setFinishEnabled( bool enable );

    void setStatus( const QString & );

signals:
    void accept();
    void reject();

private slots:
    void slotBack();
    void slotForward();
    void slotFinish();

private:
    void go( int step );

    QPtrList<QWidget> m_pages;
    QWidgetStack *m_stack;
    QuickHelp *m_quickHelp;
    QPushButton *m_cancel;
    QPushButton *m_back;
    QPushButton *m_forward;
    QPushButton *m_finish;
    QLabel *m_headerIcon;
    QLabel *m_headerText;
    KAccel *m_escapeAccel;
    QLabel *m_status;
};

#endif
