#include "Directories.moc"

#include <kurlrequester.h>
#include <kapplication.h>
#include <klocale.h>

#include <qwhatsthis.h>

Directories::Directories(QWidget *parent, const char *name)
  : DirectoriesBase(parent,name)
{
	ftpxs=0;
	
	anonRoot->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::Directory);
	guestRoot->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::Directory);
	passwd->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::File);
	shadow->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::File);
	
	QWhatsThis::add(anonRoot, i18n("Anonymous users (username <i>ftp</i> or <i>anonymous</i>) will see the directory entered here as their / directory."));
	QWhatsThis::add(guestRoot, i18n("Guest users (real users with restricted access) will see the directory entered here as their / directory."));
	QWhatsThis::add(passwd, i18n("Use the alternate passwd file specified here for authenticating users.<br>If this is left blank, the system passwd file will be used.<br>This setting can be overridden for virtual hosts."));
	QWhatsThis::add(shadow, i18n("Use the alternate shadow password file specified here for authenticating users.<br>If this is left blank, the system shadow file will be used.<br>This setting can be overridden for virtual hosts."));
}
Directories::~Directories()
{
}
void Directories::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	anonRoot->setURL(ftpxs->getAnonRoot());
	guestRoot->setURL(ftpxs->getGuestRoot());
	passwd->setURL(ftpxs->getPasswd());
	shadow->setURL(ftpxs->getShadow());
}
void Directories::update()
{
	ftpxs->setAnonRoot(anonRoot->url());
	ftpxs->setGuestRoot(guestRoot->url());
	ftpxs->setPasswd(passwd->url());
	ftpxs->setShadow(shadow->url());
}
