/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GALEON_WINDOW_H
#define GALEON_WINDOW_H

#include "galeon-embed.h"
#include "galeon-embed-persist.h"
#include "galeon-embed-popup-bw.h"
#include "galeon-sidebar.h"
#include "galeon-dialog.h"
#include <glib-object.h>
#include <glib.h>
#include <bonobo/bonobo-window.h>
#include "bookmarks-location-source.h"

G_BEGIN_DECLS

typedef struct GaleonWindowClass GaleonWindowClass;

#define GALEON_WINDOW_TYPE             (galeon_window_get_type ())
#define GALEON_WINDOW(obj)             (GTK_CHECK_CAST ((obj), GALEON_WINDOW_TYPE, GaleonWindow))
#define GALEON_WINDOW_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GALEON_WINDOW, GaleonWindowClass))
#define IS_GALEON_WINDOW(obj)          (GTK_CHECK_TYPE ((obj), GALEON_WINDOW_TYPE))
#define IS_GALEON_WINDOW_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GALEON_WINDOW))

typedef struct GaleonWindow GaleonWindow;
typedef struct GaleonWindowPrivate GaleonWindowPrivate;
typedef struct Toolbar Toolbar;

struct GaleonWindow 
{
        BonoboWindow parent;
        GaleonWindowPrivate *priv;

	/* Public to toolbar and statusbar, dont use outside */
	GObject *ui_component;
};

struct GaleonWindowClass
{
        BonoboWindowClass parent_class;
};

typedef enum
{
	NormalMode,
	FullscreenMode
} GaleonWindowMode;

typedef enum 
{
	TabsControl,
	NavControl,
	FindControl,
	ZoomControl,
	CharsetsControl,
	TitleControl,
	LocationControl,
	FaviconControl,
	StatusbarSecurityControl,
	StatusbarMessageControl,
	StatusbarProgressControl,
	StatusbarPopupBlockControl,
	SpinnerControl,
	WindowVisibilityControl,
	BMAndHistoryControl,
	TabsAppeareanceControl,
	PermissionControl,
	CssMenuControl,
} ControlID;

/* Include the header down here to resolve circular dependency */
#include "galeon-tab.h"

GType         	 galeon_window_get_type     	  (void);

GaleonWindow 	*galeon_window_new          	  (void);

void          	 galeon_window_set_chrome  	  (GaleonWindow *window,
					     	   EmbedChromeMask chrome_flags);

EmbedChromeMask  galeon_window_get_chrome	  (GaleonWindow *window);

void		 galeon_window_toggle_fullscreen  (GaleonWindow *window);

/* Tabs */

void          	 galeon_window_add_tab      	  (GaleonWindow *window, 
					     	   GaleonTab *tab,
						   gboolean jump_to);

void          	 galeon_window_remove_tab      	  (GaleonWindow *window, 
					     	   GaleonTab *tab);

void		 galeon_window_next_tab		  (GaleonWindow *window);

void		 galeon_window_prev_tab		  (GaleonWindow *window);

void		 galeon_window_jump_to_tab	  (GaleonWindow *window, 
					     	   GaleonTab *tab);

void		 galeon_window_move_tab	  	  (GaleonWindow *window, 
					     	   GaleonTab *tab,
						   GaleonTab *new_sibling);

void		 galeon_window_reparent_tab	  (GaleonWindow *window,
		                                   GaleonWindow *source,
						   GaleonTab *tab);

void		 galeon_window_set_tab_status	  (GaleonWindow *window,
		                                   GaleonTab *tab,
						   TabLoadStatus status);

void		 galeon_window_set_tab_title	  (GaleonWindow *window,
		                                   GaleonTab *tab,
						   const char *title);

void	      	 galeon_window_load_url      	  (GaleonWindow *window,
					     	   const char *url);

void		 galeon_window_set_zoom		  (GaleonWindow *window, 
						   gint zoom);

void             galeon_window_edit_location	  (GaleonWindow *window);

void          	 galeon_window_update_control 	  (GaleonWindow *window,
					    	   ControlID control);

void		 galeon_window_update_all_controls (GaleonWindow *window);

GaleonSidebar	 *galeon_window_get_sidebar	  (GaleonWindow *window);

GaleonTab    	 *galeon_window_get_active_tab 	  (GaleonWindow *window);

GaleonEmbed  	 *galeon_window_get_active_embed  (GaleonWindow *window);

GaleonEmbedPopupBW *galeon_window_get_popup_factory (GaleonWindow *window);

GList 	 	 *galeon_window_get_tabs	  (GaleonWindow *window);

Toolbar		 *galeon_window_get_toolbar	  (GaleonWindow *window);

void		  galeon_window_site_visited	  (GaleonWindow *window, 
						   const gchar *url, const gchar *title);

void              galeon_window_clear_history     (GaleonWindow *window);

/* Dialogs */

GaleonDialog     *galeon_window_get_find_dialog   (GaleonWindow *window);

void		  galeon_window_show_history	  (GaleonWindow *window);

G_END_DECLS

#endif
