/*
 *  Copyright (C) 2003  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_home_button_h
#define __galeon_home_button_h

#include "galeon-tbi.h"

/* object forward declarations */

typedef struct _GaleonHomeButton GaleonHomeButton;
typedef struct _GaleonHomeButtonClass GaleonHomeButtonClass;
typedef struct _GaleonHomeButtonPrivate GaleonHomeButtonPrivate;

/**
 * TbiZoom object
 */

#define GALEON_TYPE_HOME_BUTTON			(galeon_home_button_get_type())
#define GALEON_HOME_BUTTON(object)			(G_TYPE_CHECK_INSTANCE_CAST((object), \
							 GALEON_TYPE_HOME_BUTTON, GaleonHomeButton))
#define GALEON_HOME_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GALEON_TYPE_HOME_BUTTON,\
							 GaleonHomeButtonClass))
#define GALEON_IS_HOME_BUTTON(object)			(G_TYPE_CHECK_INSTANCE_TYPE((object), \
							 GALEON_TYPE_HOME_BUTTON))
#define GALEON_IS_HOME_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), GALEON_TYPE_HOME_BUTTON))
#define GALEON_HOME_BUTTON_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GALEON_TYPE_HOME_BUTTON,\
							 GaleonHomeButtonClass))

struct _GaleonHomeButtonClass 
{
	GaleonTbiClass parent_class;
};

/* Remember: fields are public read-only */
struct _GaleonHomeButton
{
	GaleonTbi parent_object;
	GaleonHomeButtonPrivate *priv;
};

/* this class is abstract */

GType				galeon_home_button_get_type		(void);
GaleonHomeButton *		galeon_home_button_new			(void);
void				galeon_home_button_set_sensitive	(GaleonHomeButton *b, gboolean s);

#endif
