/*-
 * customsPing.c --
 *	See if the local agent is alive
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsPing.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_Ping --
 *	See if the local agent is alive.
 *
 * Results:
 *	RPC_SUCCESS if the agent is alive and responding.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
Rpc_Stat
Customs_Ping()
{
    if (customs_Socket == -1) {
	Customs_Init();
    }
    customs_Status = Rpc_Call(customs_Socket, &customs_AgentAddr,
			  (Rpc_Proc)CUSTOMS_PING,
			  0, (Rpc_Opaque)0,
			  0, (Rpc_Opaque)0,
			  CUSTOMS_NRETRY, &customs_RetryTimeOut);
    return(customs_Status);
}

