/* Test case for buffer overflow bug in token stringification.
   See PR preprocessor/8055 for details.
   Reported by Alexander N. Kabaev <ak03@gte.com>.
   Test case written by Zack Weinberg <zack@codesourcery.com>.  */

/* { dg-do preprocess } */

#define S(x) #x

/* Fill up one internal buffer with data.  */
S(1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  1234567890123456789012345678901234567890123456789012345678901234567890
  12345678901234567890123456789012345678901234567890123)

/* When stringify_arg() was called with an empty macro argument, it would
   advance the buffer pointer by one but fail to check for running past the
   end of the buffer.  We can only know where the end of the buffer is to
   within about eight bytes, so do this sixteen times to be sure of hitting
   it.  */

S()
S()
S()
S()
S()
S()
S()
S()
S()
S()
S()
S()
S()
S()
S()
S()

/* Now allocate more memory in the buffer, which should provoke a crash.  */

S(abcdefghijklmnopqrstuvwxyz)
S(abcdefghijklmnopqrstuvwxyz)
