#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kedittoolbar.h>
#include <klibloader.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include <kstdaction.h>

#include "krichtexteditpart.h"

#include "krichtexteditor.h"
#include "krichtexteditor.moc"

KRichTextEditor::KRichTextEditor()
    : KParts::MainWindow( 0, "rich_text_editor" )
{
    (void) KStdAction::quit( qApp, SLOT( quit() ), actionCollection() );
    (void) KStdAction::configureToolbars( this, SLOT( editToolbars() ), actionCollection() );

    smb = KStdAction::showMenubar( 0, 0, actionCollection() );
    ssb = KStdAction::showStatusbar( 0, 0, actionCollection() );

    (void) KStdAction::showToolbar( "mainToolBar", actionCollection() );
    KToggleAction *kta = KStdAction::showToolbar( "formatToolBar",actionCollection(), "options_show_formatbar" );
    kta->setText( i18n("Show &Format Toolbar") );

    connect( smb, SIGNAL( toggled(bool) ), this, SLOT( setMenusVisible(bool) ) );
    connect( ssb, SIGNAL( toggled(bool) ), this, SLOT( setStatusVisible(bool) ) );

    //
    // Load the KPart
    //
    KLibFactory *factory = KLibLoader::self()->factory("libkrichtexteditpart");
    if ( !factory ) {
        KMessageBox::error( this, "Could not load editor library 'libkrichtexteditpart', aborting" );
        kapp->quit();
    }

    editpart = static_cast<KRichTextEditPart *>( factory->create( this, "krichtexteditpart",
								  "KParts::ReadWritePart" ) );
    if ( !editpart ) {
        KMessageBox::error( this, "Could not create editor part, aborting" );
        kapp->quit();
    }

    //
    // Embed and active the part
    //
    setCentralWidget( editpart->widget() );
    setXMLFile( "krichtexteditorui.rc" );
    createGUI( editpart );
}

KRichTextEditor::~KRichTextEditor()
{

}

void KRichTextEditor::show()
{
    KMainWindow::show();
    smb->setChecked( menuBar()->isVisible() );
    ssb->setChecked( statusBar()->isVisible() );
}

void KRichTextEditor::setStatusVisible( bool show )
{
    if ( show )
	statusBar()->show();
    else
	statusBar()->hide();
}

void KRichTextEditor::setMenusVisible( bool show )
{
    if ( show )
	menuBar()->show();
    else
	menuBar()->hide();
}

void KRichTextEditor::editToolbars()
{
    saveMainWindowSettings( KGlobal::config(), "MainWindow" );

    KEditToolbar dlg( factory() );
    connect( &dlg, SIGNAL( newToolbarConfig() ),
	     this, SLOT( slotNewToolbarConfig() ) );
    dlg.exec();
}

int main( int argc, char **argv )
{
    //
    // Setup App
    //
    static KCmdLineOptions options[] = {
        { "+url", I18N_NOOP( "File or URL to open" ), 0 },
        { 0, 0, 0 }
    };

    KAboutData about("krichtexteditor", I18N_NOOP("KRichTextEditor"), "0.1",
		     I18N_NOOP("A Simple Rich Text Editor"),
                     KAboutData::License_BSD,
		     I18N_NOOP("(c) 2002 Richard Moore"));
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;

    //
    // Create Window
    //
    KRichTextEditor *win = new KRichTextEditor();
    win->resize( 600, 450 );
    app.setMainWidget( win );
    app.connect( &app, SIGNAL( lastWindowClosed() ), SLOT( quit() ) );

    //
    // Process Arguments
    //
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if ( args->count() )
	win->part()->openURL( args->url(0) );

    //
    // Go!
    //
    win->show();
    return app.exec();
}

// Local Variables:
// c-basic-offset: 4
// End:
