/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * record.c - private functions for recording session into a file
 */

#include <gtk/gtk.h>
#include <unistd.h>
#include <utils.h>
#include <support.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "types.h"

gint fprec;
extern gchar *preferencesdir;
gchar *recordfile;
gboolean recording;
extern preferencestype preferences;

void startrecord(gchar *where) {
  GString *filename = g_string_new(where);
  gchar *user;

  if (filename->len == 0)
    recordfile = g_strconcat(preferences.downloaddir->str, "/", "logfile.txt", NULL);
  else { /* a full path is entered */
    if (g_strncasecmp(filename->str, "/", 1) == 0)
      recordfile = g_strdup(filename->str);
    else /* filename starts with '~' or '~<username>', replace '~' with home dir */
      if (g_strncasecmp(filename->str, "~", 1) == 0) {
        filename = g_string_erase(filename, 0, 1);
        user = g_get_user_name();
        if (g_strncasecmp(filename->str, user, strlen(user)) == 0)
          filename = g_string_erase(filename, 0, strlen(user));
        recordfile = g_strconcat(g_get_home_dir(), filename->str, NULL);
      }
      else /* just a filename, not prepended by a directory */
        recordfile = g_strconcat(preferences.downloaddir->str, "/", filename->str, NULL);
  }

  fprec = open(recordfile, O_RDWR|O_APPEND|O_CREAT, 0666);
  if (fprec == -1) writemessage(_("ERROR: Cannot open file for recording: %s\n"), g_strerror(errno), ERRORMESSAGE);
    else {
      writemessage(_("--> Recording to %s\n"), recordfile, STATUSMESSAGE);
      recording = TRUE;
    }

  g_string_free(filename, TRUE);
}

void stoprecord() {
  gint error;

  if (fprec != 0) {
    error = close(fprec);
    if (error == -1) writemessage(_("ERROR: Cannot close file: %s\n"), g_strerror(errno), ERRORMESSAGE);
      else {
        writemessage(_("--> Recording stopped\n"), NULL, STATUSMESSAGE);
        recording = FALSE;
      }
  }
}