/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <glib.h>
#include <pan/base/pan-i18n.h>

#include <pan/filters/filter-score.h>

const gchar * FILTER_SCORE_CLASS_ID = "PanObject::Filter::FilterScore";

/************
*************  PROTECTED
************/

static Filter*
filter_score_dup (const Filter * f_old)
{
	Filter * f_new = filter_score_new ();
	FilterScore * fd_old = FILTER_SCORE (f_old);
	FilterScore * fd_new = FILTER_SCORE (f_new);
	filter_class_dup (f_old, f_new);
	fd_new->minimum_score = fd_old->minimum_score;
	return f_new;
}

static gchar*
filter_score_to_string (const Filter * filter)
{
	const gint i = (gint) FILTER_SCORE(filter)->minimum_score;
	gchar * pch;

	if (filter->negate)
		pch = g_strdup_printf (_("Article's score is less than %d"), i);
	else
		pch = g_strdup_printf (_("Article's score is %d or higher"), i);

	return pch;
}

static void
filter_score_test_articles (Filter          * filter,
                            const Article  ** articles,
                            gint              article_qty,
                            gboolean        * passfail)
{
	gint i;
	gint min = FILTER_SCORE(filter)->minimum_score;

	for (i=0; i<article_qty; ++i)
		passfail[i] = articles[i]->score >= min;
}

/************
*************  PUBLIC
************/

Filter*
filter_score_new (void)
{
	FilterScore * f = g_new0 (FilterScore, 1);
	filter_constructor ((Filter*)f,
	                    filter_destructor,
	                    filter_score_test_articles,
	                    filter_score_to_string,
	                    filter_score_dup,
	                    FILTER_SCORE_CLASS_ID);
	return FILTER(f);
}
