/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmskysphere.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmskysphereedit.h"

#include <kdebug.h>
#include "pmglobals.h"
#include <klocale.h>

bool PMSkySphere::s_linkPossibilitiesCreated = false;
QValueList<PMDeclare::PMDeclareType> PMSkySphere::s_linkPossibilities;

PMSkySphere::PMSkySphere( )
      : Base( )
{
}

PMSkySphere::~PMSkySphere( )
{
}

bool PMSkySphere::isA( PMObjectType t ) const
{
   if( t == PMTSkySphere )
      return true;
   return Base::isA( t );
}

QString PMSkySphere::description( ) const
{
   return i18n( "skysphere" );
}


void PMSkySphere::serialize( PMOutputDevice& dev ) const
{
   dev.objectBegin( "sky_sphere" );
   Base::serialize( dev );
   dev.objectEnd( );
}


bool PMSkySphere::canInsert( PMObjectType t, const PMObject*,
                             const PMObjectList* ) const
{
   switch( t )
   {
      case PMTPigment:
      case PMTScale:
      case PMTRotate:
      case PMTTranslate:
      case PMTMatrix:
      case PMTComment:
      case PMTRaw:
         return true;
         break;
      default:
         return false;
         break;
   }
   return false;
}

QValueList<PMDeclare::PMDeclareType> PMSkySphere::linkPossibilities( ) const
{
   if( !s_linkPossibilitiesCreated )
   {
      s_linkPossibilities.append( PMDeclare::SkySphereDeclare );
      s_linkPossibilitiesCreated = true;
   }
   return s_linkPossibilities;
}

PMDialogEditBase* PMSkySphere::editWidget( QWidget* parent ) const
{
   return new PMSkySphereEdit( parent );
}

