/***************************************************************************
* $Id: SecretSource.java,v 1.1 2002/02/26 15:48:11 rdale Exp $
**
* Custom MIME type implementation example
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;

class SecretSource extends QLabel
{
private    int mySecret;

SecretSource( byte secret, QWidget parent )
{
	this(secret, parent, null);
}

SecretSource( byte secret, QWidget parent, String  name )
{
    super( "Secret", parent, name );
    setBackgroundColor( blue().light() );
    setFrameStyle( Box | Sunken );
    setMinimumHeight( sizeHint().height() * 2 );
    setAlignment( AlignCenter );
    mySecret = secret;
}

{
}

/* XPM */
static String  picture_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"X	c #FFFF00",
"     .....      ",
"   ..XXXXX..    ",
"  .XXXXXXXXX.   ",
" .XXXXXXXXXXX.  ",
" .XX..XXX..XX.  ",
".XXXXXXXXXXXXX. ",
".XX...XXX...XX. ",
".XXX..XXX..XXX. ",
".XXXXXXXXXXXXX. ",
".XXXXXX.XXXXXX. ",
" .XX.XX.XX.XX.  ",
" .XXX..X..XXX.  ",
"  .XXXXXXXXX.   ",
"   ..XXXXX..    ",
"     .....      ",
"                "};

void mousePressEvent( QMouseEvent  e )
{
    SecretDrag sd = new SecretDrag( (byte) mySecret, this );
    sd.setPixmap(new QPixmap(picture_xpm),new QPoint(8,8));
    sd.dragCopy();
    mySecret++;
}

}
