/***************************************************************************
                            KMacroCommand.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMACROCOMMAND_H
#define KMACROCOMMAND_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KCommand.h>

/**

 A Macro Command is a command that holds several sub-commands.
 It will appear as one to the user and in the command history,
 but it can use the implementation of multiple commands internally.
 
 @short 
 A Macro Command is a command that holds several sub-commands.
*/
@interface KMacroCommand : KCommand 

/** 
 Creates a macro command. You will then need to call @ref addCommand
 for each subcommand to be added to this macro command.

*/
- initWithText: (NSString *)name;
- (void) dealloc;

/** 
 Appends a command to this macro command.
 The ownership is transfered to the macro command.
     
*/
- addCommand: (KCommand*)command;

/** 
 Executes this command, i.e. execute all the sub-commands
 in the order in which they were added.
     
*/
- execute;

/** 
 Undoes the execution of this command, i.e. unexecute all the sub-commands
 in the _reverse_ order to the one in which they were added.
     
*/
- unexecute;
@end

#endif
