/***************************************************************************
                            KFontChooser.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFONTCHOOSER_H
#define KFONTCHOOSER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 While KFontChooser as an ordinary widget can be embedded in
 custom dialogs and therefore is very flexible, in most cases
 it is preferable to use the convenience functions in
 @ref KFontDialog.

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontChooser.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short A font selection widget.

*/

@interface KFontChooser : QWidget 

/** 
 Constructs a font picker widget.
 It normally comes up with all font families present on the system; the 
 getFont method below does allow some more fine-tuning of the selection of fonts 
 that will be displayed in the dialog.
 <p>Consider the following code snippet;<pre>

    QStringList list;
    -[KFontChooser getFontList](list,SmoothScalableFonts);
    KFontChooser chooseFont = new KFontChooser(0, "FontList", false, list);
 </pre>
 <p>The above creates a font chooser dialog with only SmoothScaleble fonts.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name onlyFixed: (BOOL)onlyFixed fontList: (NSArray *)fontList makeFrame: (BOOL)makeFrame visibleListSize: (int)visibleListSize diff: (BOOL)diff sizeIsRelativeState: (int*)sizeIsRelativeState;
- init;

/** 
 Destructs the font chooser.
   
*/
- (void) dealloc;

/** 
 Enables or disable a font column in the chooser.

 Use this
 function if your application does not need or supports all font
 properties.

*/
- enableColumn: (int)column state: (BOOL)state;

/** 
 Sets the currently selected font in the chooser.

*/
- setFont: (QFont *)font onlyFixed: (BOOL)onlyFixed;
- setFont: (QFont *)font ;

/** 

*/
- (int) fontDiffFlags;

/** 

*/
- (QFont*) font;

/** 
 Sets the color to use in the preview.
   
*/
- setColor: (QColor *)col;

/** 

*/
- (QColor*) color;

/** 
 Sets the background color to use in the preview.
   
*/
- setBackgroundColor: (QColor *)col;

/** 

*/
- (QColor*) backgroundColor;

/** 
 Sets the state of the checkbox indicating whether the font size
 is to be interpreted as relative size.
 NOTE: If parameter sizeIsRelative was not set in the constructor
       of the widget this setting will be ignored.
   
*/
- setSizeIsRelative: (int)relative;

/** 

*/
- (int) sizeIsRelative;

/** 
 Set the currently selected charset in the chooser.
   
*/
//- setCharset: (NSString *)charset;

/** 

*/
//- (NSString *) charset;

/** 

*/
- (NSString *) sampleText;

/** 
 Sets the sample text.

 Normally you should not change this
 text, but it can be better to do this if the default text is
 too large for the edit area when using the default font of your
 application.

*/
- setSampleText: (NSString *)text;

/** 
 Reimplemented for internal reasons.
   
*/
- (QSize*) sizeHint;

/** 
 Converts a @ref QFont into the corresponding X Logical Font
 Description (XLFD).

*/
+ (NSString *) getXLFD: (QFont *)theFont;

/** 
 Creates a list of font strings.

*/
+ getFontList: (NSArray *)list fontListCriteria: (unsigned int)fontListCriteria;
+ (int) FamilyList;
+ (int) StyleList;
+ (int) SizeList;
+ (int) CharsetList;
+ (int) FontDiffFamily;
+ (int) FontDiffStyle;
+ (int) FontDiffSize;
+ (int) FixedWidthFonts;
+ (int) ScalableFonts;
+ (int) SmoothScalableFonts;
@end

/** Override these methods in subclasses of KFontChooser to customise event handling behaviour */
@protocol KFontChooserEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
