/***************************************************************************
                            KSycoca.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 Read-only SYstem COnfiguration CAche
 
 See {@link KSycocaSignals} for signals emitted by KSycoca.

 

 @short *

*/
public class KSycoca extends QObject implements  DCOPObjectInterface {
	protected KSycoca(Class dummy){super((Class) null);}

	private native void newKSycoca();

/** 
 Read-only database
    
*/
	public KSycoca() {
		super((Class) null);
		newKSycoca();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

 This is how factories get a stream to an entry
    
*/
	public native QDataStream findEntry( int offset, int type);

/** 

    
*/
	public native QDataStream findFactory( int identifier);

/** 

    
*/
	public native String kfsstnd_prefixes();

/** 

    
*/
	public native String language();

/** 

 The database contains all changes made _before_ this time and
 _might_ contain changes made after that.
    
*/
	public native int timeStamp();

/** 

 Signature that keeps track of changes to 
 $KDEDIR/share/services/update_ksycoca

 Touching this file causes the database to be recreated
 from scratch.
    
*/
	public native int updateSignature();

/** 

    
*/
	public native void addFactory( int arg1);

/** 

*/
	public native boolean isBuilding();
//	public native k_dcop: /** * internal function for receiving kded/kbuildsycoca's signal, when the sycoca file changes */ void notifyDatabaseChanged( String[] arg1);

/** 
 Get or create the only instance of KSycoca (read-only)
    
*/
	public static native KSycoca self();

/** 
 Determine relative path for a .desktop file from a full path and a resource name
    
*/
	public static native String determineRelativePath( String _fullpath, String _resource);

/** 
 When you receive a "databaseChanged" signal, you can query here if
 a change has occured in a specific resource type.

*/
	public static native boolean isChanged( String type);

/** 
 A read error occurs.
    
*/
	public static native void flagError();

/** 
 Returns read error status and clears flag.
    
*/
	public static native boolean readError();
	private native void newKSycoca( boolean arg1);

/** 

 Building database
    
*/
	public KSycoca( boolean arg1) {
		super((Class) null);
		newKSycoca( arg1);
	}
	protected native boolean checkVersion( boolean abortOnError);
	protected native boolean checkVersion();
	protected native boolean openDatabase( boolean openDummyIfNotFound);
	protected native boolean openDatabase();
	protected native void closeDatabase();
	protected native void virtual_hook( int identifier, int data);

 	// From DCOPObjectInterface

 /**
 Returns the object id of the DCOPObject.

*/
	public native String objId();

/**
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

*/
	public native boolean setObjId( String objId);

/**
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns false, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation. It handles the functions "functions()" and
 "interfaces()" which return the lists of supported functions
 and interfaces, respectively.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #functions} but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
	public native ArrayList functionsDynamic();

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #interfaces} but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
	public native ArrayList interfacesDynamic();

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/**
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/**
 Connects to a DCOP signal.

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnects a DCOP signal.

 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**
 Returns the {@link DCOPClient} responsible for making the call.
 Only call this function while you are handling a DCOP call.

*/
	public native DCOPClient callingDcopClient();

/**

*/
	public native void setCallingDcopClient( DCOPClient arg1);
}
