/***************************************************************************
                            KDirWatch.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Watch directories and files for changes.
 The watched directories or files doesn't have to exist yet.

 When a watched directory is changed, i.e. when files therein are
 created or deleted, KDirWatch will emit the signal {@link #dirty}.

 When a watched, but previously not existing directory gets created,
 KDirWatch will emit the signal {@link #created}.

 When a watched directory gets deleted, KDirWatch will emit the
 signal {@link #deleted}. The directory is still watched for new
 creation.

 When a watched file is changed, i.e. attributes changed or written
 to, KDirWatch will emit the signal {@link #fileDirty}.

 Scanning of particular directories or files can be stopped temporarily
 and restarted. The whole class can be stopped and restarted.
 Directories and files can be added/removed from list in any state.

 The implementation uses the FAM service when available;
 if FAM is not available, the DNOTIFY functionality is used on LINUX.
 As a last resort, a regular polling for change of modification times
 is done; the polling interval is a global config option:
 DirWatch/PollInterval and DirWatch/NFSPollInterval for NFS mounted
 directories.

 See {@link KDirWatchSignals} for signals emitted by KDirWatch.

 

 @author Sven Radej <sven@lisa.exp.univie.ac.at>
  
 @short Class for watching directory and file changes.

*/
public class KDirWatch extends QObject  {
	protected KDirWatch(Class dummy){super((Class) null);}

	private native void newKDirWatch( QObject parent, String name);

/** 
 Constructor.

 Scanning begins immediatly when a dir/file watch
 is added.
    
*/
	public KDirWatch( QObject parent, String name) {
		super((Class) null);
		newKDirWatch( parent, name);
	}
	private native void newKDirWatch();
	public KDirWatch() {
		super((Class) null);
		newKDirWatch();
	}

/** 
 Destructor.

 Stops scanning and cleans up.
    
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Adds a directory to be watched.

 The directory does not have to exist. When <code>watchFiles</code> is
 false (the default), the signals dirty(), created(), deleted()
 can be emitted, all for the watched directory.
 When <code>watchFiles</code> is true, all files in the watched directory
 are looked for changes, too. Thus, the signals fileDirty(),
 fileCreated(), fileDeleted() can be emitted.

 When <code>recursive</code> is true, also all sub directories are watched.
    
*/
	public native void addDir( String path, boolean watchFiles, boolean recursive);
	public native void addDir( String path);

/** 
 Adds a file to be watched.

    
*/
	public native void addFile( String file);

/** 
 Returns the time the directory/file was last changed.
    
*/
	public native Calendar ctime( String path);

/** 
 Removes a directory from the list of scanned directories.

 If specified path is not in the list this does nothing.
    
*/
	public native void removeDir( String path);

/** 
 Removes a file from the list of watched files.

 If specified path is not in the list this does nothing.
    
*/
	public native void removeFile( String file);

/** 
 Stops scanning the specified path.

 The <code>path</code> is not deleted from the interal just, it is just skipped.
 Call this function when you perform an huge operation
 on this directory (copy/move big files or many files). When finished,
 call {@link #restartDirScan}.
 Returns <code>false</code> if specified path is not in list, <code>true</code> otherwise.
    
*/
	public native boolean stopDirScan( String path);

/** 
 Restarts scanning for specified path.

 Resets ctime. It doesn't notify
 the change (by emitted a signal), since the ctime value is reset.

 Call it when you are finished with big operations on that path,
 <em>and</em> when <em>you</em> have refreshed that path.  Returns <code>false</code>
 if specified path is not in list, <code>true</code> otherwise.  
    
*/
	public native boolean restartDirScan( String path);

/** 
 Starts scanning of all dirs in list.

 If notify is <code>true</code>, all changed directories (since {@link #stopScan} call) will be notified for refresh. If notify is
 <code>false</code>, all ctimes will be reset (except those who are stopped,
 but only if <code>skippedToo</code> is <code>false</code>) and changed dirs won't be
 notified. You can start scanning even if the list is
 empty. First call should be called with <code>false</code> or else all 
 directories 
 in list will be notified.  If
 <code>skippedToo</code> is true, the skipped directoris (scanning of which was
 stopped with {@link #stopDirScan} ) will be reset and notified
 for change.  Otherwise, stopped directories will continue to be
 unnotified.
    
*/
	public native void startScan( boolean notify, boolean skippedToo);
	public native void startScan();

/** 
 Stops scanning of all directories in internal list.

 The timer is stopped, but the list is not cleared.
    
*/
	public native void stopScan();

/** 
 Is scanning stopped?
 After creation of a KDirWatch instance, this is false.
    
*/
	public native boolean isStopped();

/** 
 Check if a directory is being watched by this KDirWatch instance
    
*/
	public native boolean contains( String path);

/**  {@link #created} 
*/
	public native void setCreated( String arg1);

/**  {@link #dirty} 
*/
	public native void setDirty( String arg1);

/**  {@link #deleted} 
*/
	public native void setDeleted( String arg1);

/** 
 Dump statistic information about all KDirWatch instances.
 This checks for consistency, too.
    
*/
	public static native void statistics();

/** 
 The KDirWatch instance usually globally used in an application.
 It is automatically deleted when the application exits.

 However, you can create an arbitrary number of KDirWatch instances
 aside from this one - for those you have to take care of memory management.
    
*/
	public static native KDirWatch self();

/** 
 Return true if KDirWatch.self() exists

*/
	public static native boolean exists();
}
