/***************************************************************************
                            Document.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> Document </code> interface represents the entire HTML or
 XML document. Conceptually, it is the root of the document tree,
 and provides the primary access to the document's data.

  Since elements, text nodes, comments, processing instructions,
 etc. cannot exist outside the context of a <code> Document </code>
 , the <code> Document </code> interface also contains the factory
 methods needed to create these objects. The <code> Node </code>
 objects created have a <code> ownerDocument </code> attribute which
 associates them with the <code> Document </code> within whose
 context they were created.

 
 @short *
 The <code> Document </code> interface represents the entire HTML or
 XML document.
*/
public class DOMDocument extends DOMNode  {
	protected DOMDocument(Class dummy){super((Class) null);}

	private native void newDOMDocument();
	public DOMDocument() {
		super((Class) null);
		newDOMDocument();
	}
	private native void newDOMDocument( boolean arg1);

/** 
 don't create an implementation if false
 use at own risk
     
*/
	public DOMDocument( boolean arg1) {
		super((Class) null);
		newDOMDocument( arg1);
	}
	private native void newDOMDocument( DOMDocument other);
	public DOMDocument( DOMDocument other) {
		super((Class) null);
		newDOMDocument( other);
	}
	private native void newDOMDocument( DOMNode other);
	public DOMDocument( DOMNode other) {
		super((Class) null);
		newDOMDocument( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 The Document Type Declaration (see <code> DocumentType </code>
 ) associated with this document. For HTML documents as well as
 XML documents without a document type declaration this returns
 <code> null </code> . The DOM Level 1 does not support editing
 the Document Type Declaration, therefore <code> docType </code>
 cannot be altered in any way.

     
*/
	public native DocumentType doctype();

/** 
 The <code> DOMImplementation </code> object that handles this
 document. A DOM application may use objects from multiple
 implementations.

     
*/
//	public native DOMImplementation implementation();

/** 
 This is a convenience attribute that allows direct access to
 the child node that is the root element of the document. For
 HTML documents, this is the element with the tagName "HTML".

     
*/
	public native Element documentElement();

/** 
 Creates an element of the type specified. Note that the
 instance returned implements the Element interface, so
 attributes can be specified directly on the returned object.

     
*/
	public native Element createElement( String tagName);

/** 
 Introduced in DOM Level 2
 Creates an element of the given qualified name and namespace URI.

*/
	public native Element createElementNS( String namespaceURI, String qualifiedName);

/** 
 Creates an empty <code> DocumentFragment </code> object.

     
*/
	public native DocumentFragment createDocumentFragment();

/** 
 Creates a <code> Text </code> node given the specified string.

     
*/
	public native Text createTextNode( String data);

/** 
 Creates a <code> Comment </code> node given the specified
 string.

     
*/
	public native Comment createComment( String data);

/** 
 Creates a <code> CDATASection </code> node whose value is the
 specified string.

     
*/
	public native CDATASection createCDATASection( String data);

/** 
 Creates a <code> ProcessingInstruction </code> node given the
 specified name and data strings.

  NOT_SUPPORTED_ERR: Raised if this document is an HTML
 document.

     
*/
	public native ProcessingInstruction createProcessingInstruction( String target, String data);

/** 
 Creates an <code> Attr </code> of the given name. Note that the
 <code> Attr </code> instance can then be set on an <code>
 Element </code> using the <code> setAttribute </code> method.

     
*/
	public native Attr createAttribute( String name);

/** 
 Introduced in DOM Level 2
 Creates an attribute of the given qualified name and namespace URI.
 HTML-only DOM implementations do not need to implement this method.

*/
	public native Attr createAttributeNS( String namespaceURI, String qualifiedName);

/** 
 Creates an EntityReference object.

  NOT_SUPPORTED_ERR: Raised if this document is an HTML
 document.

     
*/
	public native EntityReference createEntityReference( String name);

/** 
 Moved from HTMLDocument in DOM Level 2
 Returns the Element whose <code> id </code> is given by
 elementId. If no such element exists, returns <code> null
 </code> . Behavior is not defined if more than one element has
 this <code> id </code> .

     
*/
	public native Element getElementById( String elementId);

/** 
 No Exceptions.

 Returns a <code> NodeList </code> of all the <code> Element
 </code> s with a given tag name in the order in which they
 would be encountered in a preorder traversal of the <code>
 Document </code> tree.

     
*/
	public native ArrayList getElementsByTagName( String tagname);

/** 
 Introduced in DOM Level 2
 No Exceptions

 Returns a NodeList of all the Elements with a given local name and
 namespace URI in the order in which they are encountered in a preorder
 traversal of the Document tree.

*/
	public native ArrayList getElementsByTagNameNS( String namespaceURI, String localName);

/** 
 Introduced in DOM Level 2

 Imports a node from another document to this document. The returned node
 has no parent; (parentNode is null). The source node is not altered or
 removed from the original document; this method creates a new copy of
 the source node.

 For all nodes, importing a node creates a node object owned by the
 importing document, with attribute values identical to the source node's
 nodeName and nodeType, plus the attributes related to namespaces
 (prefix, localName, and namespaceURI).

 As in the cloneNode operation on a Node, the source node is not altered.
 Additional information is copied as appropriate to the nodeType,
 attempting to mirror the behavior expected if a fragment of XML or HTML
 source was copied from one document to another, recognizing that the two
 documents may have different DTDs in the XML case. The following list
 describes the specifics for each type of node.

 ATTRIBUTE_NODE
 The ownerElement attribute is set to null and the specified flag is set
 to true on the generated Attr. The descendants of the source Attr are
 recursively imported and the resulting nodes reassembled to form the
 corresponding subtree. Note that the deep parameter has no effect on
 Attr nodes; they always carry their children with them when imported.

 DOCUMENT_FRAGMENT_NODE
 If the deep option was set to true, the descendants of the source
 element are recursively imported and the resulting nodes reassembled to
 form the corresponding subtree. Otherwise, this simply generates an
 empty DocumentFragment.

 DOCUMENT_NODE
 Document nodes cannot be imported.

 DOCUMENT_TYPE_NODE
 DocumentType nodes cannot be imported.

 ELEMENT_NODE
 Specified attribute nodes of the source element are imported, and the
 generated Attr nodes are attached to the generated Element. Default
 attributes are not copied, though if the document being imported into
 defines default attributes for this element name, those are assigned. If
 the importNode deep parameter was set to true, the descendants of the
 source element are recursively imported and the resulting nodes
 reassembled to form the corresponding subtree.

 ENTITY_NODE
 Entity nodes can be imported, however in the current release of the DOM
 the DocumentType is readonly. Ability to add these imported nodes to a
 DocumentType will be considered for addition to a future release of the
 DOM.
 On import, the publicId, systemId, and notationName attributes are
 copied. If a deep import is requested, the descendants of the the source
 Entity are recursively imported and the resulting nodes reassembled to
 form the corresponding subtree.

 ENTITY_REFERENCE_NODE Only the EntityReference itself is copied, even if
 a deep import is requested, since the source and destination documents
 might have defined the entity differently. If the document being
 imported into provides a definition for this entity name, its value is
 assigned.

 NOTATION_NODE
 Notation nodes can be imported, however in the current release of the
 DOM the DocumentType is readonly. Ability to add these imported nodes to
 a DocumentType will be considered for addition to a future release of
 the DOM.
 On import, the publicId and systemId attributes are copied.
 Note that the deep parameter has no effect on Notation nodes since they
 never have any children.

 PROCESSING_INSTRUCTION_NODE
 The imported node copies its target and data values from those of the
 source node.

 TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE
 These three types of nodes inheriting from CharacterData copy their data
 and length attributes from those of the source node.

*/
	public native DOMNode importNode( DOMNode importedNode, boolean deep);

/** 

 not part of the DOM
     
*/
	public native boolean isHTMLDocument();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentRange interface

*/
	public native Range createRange();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentTraversal interface

 Create a new NodeIterator over the subtree rooted at the specified node.

*/
	public native NodeIterator createNodeIterator( DOMNode root, long whatToShow, NodeFilter filter, boolean entityReferenceExpansion);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentTraversal interface

 Create a new TreeWalker over the subtree rooted at the specified node.

*/
	public native TreeWalker createTreeWalker( DOMNode root, long whatToShow, NodeFilter filter, boolean entityReferenceExpansion);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentEvent interface

 The createEvent method is used in creating Events when it is either
 inconvenient or unnecessary for the user to create an Event themselves.
 In cases where the implementation provided Event is insufficient, users
 may supply their own Event implementations for use with the
 dispatchEvent method.

*/
//	public native Event createEvent( String eventType);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentView interface

 The default AbstractView for this Document, or null if none available.
     
*/
//	public native AbstractView defaultView();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentStyle interface

 A list containing all the style sheets explicitly linked into or
 embedded in a document. For HTML documents, this includes external style
 sheets, included via the HTML LINK element, and inline STYLE elements.
 In XML, this includes external style sheets, included via style sheet
 processing instructions (see [XML-StyleSheet]).
     
*/
//	public native StyleSheetList styleSheets();

/** 

*/
	public native KHTMLView view();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentCSS interface

 This method is used to retrieve the override style declaration for a
 specified element and a specified pseudo-element.

*/
	public native CSSStyleDeclaration getOverrideStyle( Element elt, String pseudoElt);

/** 
 not part of the DOM

 completes a given URL
     
*/
	public native String completeURL( String url);
}
