/***************************************************************************
                            kde_KPanelMenu.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPANELMENU
#define KDE_KPANELMENU

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Base class to build dynamically loaded menu entries for the K-menu, or the panel.

 This class allows to build menu entries that will be dynamically added either to
 the K-menu, or to the panel as a normal button. These dynamic menus are located
 in shared libraries that will be loaded at runtime by Kicker (the KDE panel).

 To build such a menu, you have to inherit this class and implement the pure virtual
 functions #initialize() and @ref slotExec(). You also have to provide a factory
 object in your library, see @ref KLibFactory. This factory is only used to construct
 the menu object.

 Finally, you also have to provide a desktop file describing your dynamic menu. The
 relevant entries are: Name, Comment, Icon and X-KDE-Library (which contains the
 library name without any extension). This desktop file has to be installed in
 $KDEDIR/share/apps/kicker/menuext/.

 @author The kicker maintainer, Michael Goffioul <goffioul@imec.be>
 
 @short Base class to build dynamically loaded menu entries for the K-menu, or the panel.

*/

/** *
 Destructor.
     
*/
void kde_del_KPanelMenu( kde_KPanelMenu* p );

/** *
 Get the directory path associated with this menu, or QString::null if
 there's no such associated path.

*/
qt_QString * kde_KPanelMenu_path(kde_KPanelMenu* instPointer);

/** *
 Set a directory path to be associated with this menu.

*/
void kde_KPanelMenu_setPath(kde_KPanelMenu* instPointer,qt_QString * p);

/** *
 Tell if the menu has been initialized, that is it already contains items.
 This is useful when you need to know if you have to clear the menu, or to
 fill it.

*/
int kde_KPanelMenu_initialized(kde_KPanelMenu* instPointer);

/** *
 Set the initial state. Set it to true when you menu is filled with the items
 you want.

*/
void kde_KPanelMenu_setInitialized(kde_KPanelMenu* instPointer,int on);

/** *
 Disable the automatic clearing of the menu. Kicker uses a cache system for
 its menus. After a specific configurable delay, the menu will be cleared.
 Use this function if you want to disable kicker's cache system, and avoid
 the clearing of your menu.
     
*/
void kde_KPanelMenu_disableAutoClear(kde_KPanelMenu* instPointer);

/** *
 Reinitialize the menu: the menu is first cleared, the initial state is set
 to false, and finally #initialize() is called. Use this if you want to
 refill your menu immediately.
     
*/
void kde_KPanelMenu_reinitialize(kde_KPanelMenu* instPointer);

/** *
 Deinitialize the menu: the menu is cleared and the initialized state is set to
 false. #initialize() is NOT called. It will be called before the menu is
 next shown, however. Use this slot if you want a delayed reinitialization.

*/
void kde_KPanelMenu_deinitialize(kde_KPanelMenu* instPointer);

#endif
