// pageSizeDialog.cpp
//
// Part of KVIEWSHELL - A framework for multipage text/gfx viewers
//
// (C) 2002 Stefan Kebekus
// Distributed under the GPL

// Add header files alphabetically

#include <kapplication.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qhbox.h>

#include "pageSizeDialog.h"
#include "pageSizeWidget.h"


pageSizeDialog::pageSizeDialog( QWidget *parent, const char *name, bool modal)
  :KDialogBase( parent, name, modal, i18n("Page Size"), Ok|Apply|Cancel, Ok, 
		true )
{
  pageSizeW = new pageSizeWidget(this, "PageSizeWidget");
  pageSizeW->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, 0, 0, 
					 pageSizeW->sizePolicy().hasHeightForWidth() ) );
  setMainWidget(pageSizeW);
}


void pageSizeDialog::slotOk()
{
  emit(sizeSelected(pageSizeW->serialize(), pageSizeW->orientationChoice->currentItem()));
  accept();
}


void pageSizeDialog::slotApply()
{
  emit(sizeSelected(pageSizeW->serialize(), pageSizeW->orientationChoice->currentItem()));
}


void pageSizeDialog::setPageSize(QString name)
{
  if (pageSizeW == 0)
    return;
  pageSizeW->setPageSize(name);
}

void pageSizeDialog::setOrientation(int ori)
{
  if (pageSizeW != 0)
    pageSizeW->setOrientation(ori);
}

#include "pageSizeDialog.moc"
