/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsPopupWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;

public class WindowsPopupFactory
extends PopupFactory {
    private static final Object SharedInstanceKey = new StringBuffer("PopupFactory.SharedInstanceKey");
    private static final int MAX_CACHE_SIZE = 5;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup;

    public Popup getPopup(Component component, Component component2, int n2, int n3) throws IllegalArgumentException {
        if (component2 == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        Popup popup = HeavyWeightPopup.getHeavyWeightPopup(component, component2, n2, n3);
        return popup != null ? popup : super.getPopup(component, component2, n2, n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DefaultFrame
    extends Frame {
        DefaultFrame() {
        }
    }

    private static class HeavyWeightPopup
    extends Popup {
        private static final Object heavyWeightPopupCacheKey = new StringBuffer("PopupFactory.heavyWeightPopupCache");
        private WindowsPopupWindow window;

        static Popup getHeavyWeightPopup(Component component, Component component2, int n2, int n3) {
            Window window = component != null ? SwingUtilities.getWindowAncestor(component) : null;
            HeavyWeightPopup heavyWeightPopup = null;
            if (window != null) {
                heavyWeightPopup = HeavyWeightPopup.getRecycledHeavyWeightPopup(window);
            }
            if (heavyWeightPopup == null) {
                heavyWeightPopup = new HeavyWeightPopup();
            }
            heavyWeightPopup.reset(component, component2, n2, n3);
            return heavyWeightPopup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static HeavyWeightPopup getRecycledHeavyWeightPopup(Window window) {
            Class clazz = class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup == null ? (class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup = WindowsPopupFactory.class$("com.sun.java.swing.plaf.windows.WindowsPopupFactory$HeavyWeightPopup")) : class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (!map.containsKey(window)) {
                    return null;
                }
                List list = (List)map.get(window);
                int n2 = list.size();
                if (n2 > 0) {
                    HeavyWeightPopup heavyWeightPopup = (HeavyWeightPopup)list.get(0);
                    list.remove(0);
                    return heavyWeightPopup;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map getHeavyWeightPopupCache() {
            Class clazz = class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup == null ? (class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup = WindowsPopupFactory.class$("com.sun.java.swing.plaf.windows.WindowsPopupFactory$HeavyWeightPopup")) : class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                Map map = (Map)AppContext.getAppContext().get(heavyWeightPopupCacheKey);
                if (map == null) {
                    map = new HashMap(2);
                    AppContext.getAppContext().put(heavyWeightPopupCacheKey, map);
                }
                return map;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleHeavyWeightPopup(HeavyWeightPopup heavyWeightPopup) {
            Class clazz = class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup == null ? (class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup = WindowsPopupFactory.class$("com.sun.java.swing.plaf.windows.WindowsPopupFactory$HeavyWeightPopup")) : class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                List list;
                Window window = SwingUtilities.getWindowAncestor(heavyWeightPopup.getWindow());
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (window instanceof DefaultFrame) {
                    return;
                }
                if (map.containsKey(window)) {
                    list = (List)map.get(window);
                } else {
                    list = new ArrayList();
                    map.put(window, list);
                    Window window2 = window;
                    window2.addWindowListener(new WindowAdapter(window2){
                        private final /* synthetic */ Window val$w;
                        {
                            this.val$w = window;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void windowClosed(WindowEvent windowEvent) {
                            Class clazz = class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup == null ? (class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup = WindowsPopupFactory.class$("com.sun.java.swing.plaf.windows.WindowsPopupFactory$HeavyWeightPopup")) : class$com$sun$java$swing$plaf$windows$WindowsPopupFactory$HeavyWeightPopup;
                            synchronized (clazz) {
                                Map map = HeavyWeightPopup.access$000();
                                map.remove(this.val$w);
                            }
                        }
                    });
                }
                if (list.size() < 5) {
                    list.add(heavyWeightPopup);
                }
            }
        }

        HeavyWeightPopup() {
        }

        HeavyWeightPopup(Component component, Component component2, int n2, int n3) {
            if (component2 == null) {
                throw new IllegalArgumentException("Contents must be non-null");
            }
            this.reset(component, component2, n2, n3);
        }

        public WindowsPopupWindow getWindow() {
            return this.window;
        }

        public void show() {
            if (this.window != null) {
                this.window.show();
            }
        }

        public void hide() {
            this.window.hide();
            this.window.getContentPane().removeAll();
            HeavyWeightPopup.recycleHeavyWeightPopup(this);
        }

        void reset(Component component, Component component2, int n2, int n3) {
            if (this.window == null) {
                this.window = this.createWindow(component);
            }
            if (WindowsLookAndFeel.useNativeAnimation) {
                if (component2 instanceof JToolTip) {
                    this.window.setWindowType(1);
                } else if (component2 instanceof JPopupMenu) {
                    if (component instanceof JComboBox) {
                        this.window.setWindowType(5);
                    } else if (component instanceof JMenu) {
                        if (((JMenu)component).isTopLevelMenu()) {
                            this.window.setWindowType(2);
                        } else {
                            this.window.setWindowType(3);
                        }
                    } else {
                        this.window.setWindowType(4);
                    }
                }
            }
            this.window.setLocation(n2, n3);
            this.window.getContentPane().add(component2, "Center");
            this.window.invalidate();
            this.window.pack();
        }

        WindowsPopupWindow createWindow(Component component) {
            return new WindowsPopupWindow(this.getParentWindow(component));
        }

        private Window getParentWindow(Component component) {
            Window window = null;
            if (component instanceof Window) {
                window = (Window)component;
            } else if (component != null) {
                window = SwingUtilities.getWindowAncestor(component);
            }
            if (window == null) {
                window = new DefaultFrame();
            }
            return window;
        }

        static /* synthetic */ Map access$000() {
            return HeavyWeightPopup.getHeavyWeightPopupCache();
        }
    }
}

