/*
 * kab3.cpp
 */

#include "kab3.h"

#include <kkeydialog.h>
#include <kconfig.h>
#include <kurl.h>
#include <kdebug.h>
#include <kedittoolbar.h>

#include <kaction.h>
#include <kstdaction.h>

#include <klibloader.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include <klocale.h>

kab3::kab3()
    : KParts::MainWindow( 0L, "kab3" )
{
    setXMLFile("kab3_shell.rc");

    setupActions();

    statusBar()->show();

    // this routine will find and load our Part.  it finds the Part by
    // name which is a bad idea usually.. but it's alright in this
    // case since our Part is made for this Shell
    KLibFactory *factory = KLibLoader::self()->factory("libkab3part");
    if (factory)
    {
        // now that the Part is loaded, we cast it to a Part to get
        // our hands on it
        m_part = static_cast<KParts::ReadWritePart *>(factory->create(this,
                                "kab3_part", "KParts::ReadWritePart" ));

        if (m_part)
        {
            // tell the KParts::MainWindow that this is indeed the main widget
            setCentralWidget(m_part->widget());

            // and integrate the part's GUI with the shell's
            createGUI(m_part);
        }
    }
    else
    {
        // if we couldn't find our Part, we exit since the Shell by
        // itself can't do anything useful
        KMessageBox::error
            (this,
             i18n("Cannot load the KPart for KAB MkIII. Check your installation."));
        kapp->quit();
    }
  applyMainWindowSettings(KGlobal::config(), "Main Window");
}

bool kab3::queryClose()
{
    kdDebug() << "kab3::queryClose: saving window state." << endl;
    saveMainWindowSettings(KGlobal::config(), "Main Window");
    return true;
}

kab3::~kab3()
{
}

void kab3::load(const KURL& url)
{
    m_part->openURL( url );
}

void kab3::setupActions()
{
    KStdAction::openNew(this, SLOT(fileNew()), actionCollection());
    KStdAction::quit(kapp, SLOT(quit()), actionCollection());

    m_toolbarAction = KStdAction::showToolbar(this, SLOT(optionsShowToolbar()), actionCollection());
    m_statusbarAction = KStdAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());

    KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
    KStdAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), actionCollection());
}

void kab3::saveProperties(KConfig* /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored
    saveMainWindowSettings(KGlobal::config(), "Main Window");
}

void kab3::readProperties(KConfig* /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'
}

void kab3::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

    // create a new window
    (new kab3)->show();
}


void kab3::optionsShowToolbar()
{
    // this is all very cut and paste code for showing/hiding the
    // toolbar
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void kab3::optionsShowStatusbar()
{
    // this is all very cut and paste code for showing/hiding the
    // statusbar
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void kab3::optionsConfigureKeys()
{
    KKeyDialog::configureKeys(actionCollection(), "kab3_shell.rc");
}

void kab3::optionsConfigureToolbars()
{
    saveMainWindowSettings(KGlobal::config(), "MainWindow");

    // use the standard toolbar editor
    KEditToolbar dlg(factory());
    connect(&dlg, SIGNAL(newToolbarConfig()),
            this, SLOT(applyNewToolbarConfig()));
    dlg.exec();
}

void kab3::applyNewToolbarConfig()
{
    applyMainWindowSettings(KGlobal::config(), "MainWindow");
}

#include "kab3.moc"
