#include "piece.h"

#include <qpainter.h>


const KSPieceInfo::Form KSPieceInfo::FORMS[NB_FORMS] = {
    { {{-1, -1,  0,  0}, {-1,  0,  0,  1}, {-1, -1,  0,  0}, {-1,  0,  0,  1}},
      {{ 1,  0,  0, -1}, {-1, -1,  0,  0}, { 1,  0,  0, -1}, {-1, -1,  0,  0}},
      2 }, // broken line Z
    { {{-1, -1,  0,  0}, {-1,  0,  0,  1}, {-1, -1,  0,  0}, {-1,  0,  0,  1}},
      {{-1,  0,  0,  1}, { 0,  0, -1, -1}, {-1,  0,  0,  1}, { 0,  0, -1, -1}},
      2 }, // broken line S
	{ {{ 0,  0,  0,  0}, {-1,  0,  1,  2}, { 0,  0,  0,  0}, {-1,  0,  1,  2}},
      {{-1,  0,  1,  2}, { 0,  0,  0,  0}, {-1,  0,  1,  2}, { 0,  0,  0,  0}},
      2 }, // line
    { {{ 0,  0,  1,  0}, {-1,  1,  0,  0}, { 0,  0, -1,  0}, { 1, -1,  0,  0}},
      {{ 1, -1,  0,  0}, { 0,  0,  1,  0}, {-1,  1,  0,  0}, { 0,  0, -1,  0}},
      4 }, // T
	{ {{-1,  0, -1,  0}, {-1,  0, -1,  0}, {-1,  0, -1,  0}, {-1,  0, -1,  0}},
	  {{ 0,  0, -1, -1}, { 0,  0, -1, -1}, { 0,  0, -1, -1}, { 0,  0, -1, -1}},
      1 }, // square
	{ {{ 1,  1,  1,  0}, {-1,  0,  1,  1}, {-1, -1, -1,  0}, { 1,  0, -1, -1}},
	  {{ 1,  0, -1, -1}, { 1,  1,  1,  0}, {-1,  0,  1,  1}, {-1, -1, -1,  0}},
       4 }, // backward L
    { {{-1, -1, -1,  0}, {-1,  0,  1,  1}, { 1,  1,  1,  0}, { 1,  0, -1, -1}},
	  {{ 1,  0, -1, -1}, {-1, -1, -1,  0}, {-1,  0,  1,  1}, { 1,  1,  1,  0}},
       4 }  // L
};


const QColor KSPieceInfo::COLORS[NB_FORMS + 1] = {
    // normal
	QColor(200, 100, 100), // red
	QColor(100, 200, 100), // green
	QColor(100, 100, 200), // blue
	QColor(200, 200, 100), // yellow
	QColor(200, 100, 200), // violet
	QColor(100, 200, 200), // dirty orange
	QColor(218, 170,   0), // light blue
    // garbage
    QColor(100, 100, 100)  // gray
};

void KSPieceInfo::draw(QPixmap *pixmap, uint blockType, uint,
                       bool lighted) const
{
    QColor color = COLORS[blockType];
	if (lighted) color = color.light();
	pixmap->fill(color);

	QPainter p(pixmap);
    QRect r = pixmap->rect();

	p.setPen( color.light() );
	p.moveTo(r.bottomLeft());
	p.lineTo(r.topLeft());
	p.lineTo(r.topRight());

	p.setPen( color.dark() );
	p.moveTo(r.topRight() + QPoint(0,1));
	p.lineTo(r.bottomRight());
	p.lineTo(r.bottomLeft() + QPoint(1,0));
}
