#ifndef KS_BOARD_H
#define KS_BOARD_H

#include "common/board.h"


class KSBoard : public Board
{
 Q_OBJECT
 public:
	KSBoard(bool graphic, QWidget *parent);
	void copy(const GenericTetris &);

	void init(const GTInitData &);

 signals:
    void removedLinesUpdated(uint nb, uint totalRemoved);

 private:
	uint gift();
	bool putGift(uint nb);
	bool _putGift(uint nb);
	bool needRemoving();
    void remove();
    bool toBeRemoved(const Coord &) const;
    bool toFall(const Coord &) const;
    void computeInfos();

	QMemArray<uint> filled;
    QMemArray<uint> linesRemoved;
	uint            addRemoved;
};

#endif
