#include <qpainter.h>
#include <qdrawutil.h>
#include <qtimer.h>

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include "kasitem.h"

#include "kaspopup.h"
#include "kasitem.moc"

KasItem::KasItem( KasBar *parent )
   : QObject( parent ),
     kas( parent ), pop( 0 ),
     popupTimer( 0 ), dragTimer( 0 ),
     mouseOver( false ), customPopup( false )
{
}

KasItem::~KasItem()
{
   if ( pop )
      delete pop;
}

void KasItem::mouseEnter()
{
   static const int POPUP_DELAY = 300;

   if ( (!customPopup) && (popupTimer == 0) ) {
      popupTimer = new QTimer( this, "popupTimer" );
      connect( popupTimer, SIGNAL( timeout() ), SLOT( showPopup() ) );
      popupTimer->start( POPUP_DELAY, true );
   }

   mouseOver = true;
   update( false );
}

void KasItem::dragEnter()
{
   static const int DRAG_SWITCH_DELAY = 1000;

   if ( dragTimer == 0 ) {
      dragTimer = new QTimer( this, "dragTimer" );
      connect( dragTimer, SIGNAL( timeout() ), SLOT( dragOverAction() ) );
      dragTimer->start( DRAG_SWITCH_DELAY, true );
   }

   mouseOver = true;
   update( false );
}

void KasItem::mouseLeave()
{
   if ( popupTimer ) {
      delete popupTimer;
      popupTimer = 0;
   }
   if ( (!customPopup) && pop )
      hidePopup();

   mouseOver = false;
   update( false );
}

void KasItem::dragLeave()
{
   if ( dragTimer ) {
      delete dragTimer;
      dragTimer = 0;
   }

   mouseOver = false;
   update( false );
}

void KasItem::showPopup()
{
   if ( pop )
      return;

   pop = createPopup();
   if ( pop )
      pop->show();
}

void KasItem::hidePopup()
{
   if ( pop ) 
      delete pop;
   pop = 0;
   update();
}

void KasItem::togglePopup()
{
   if ( pop )
      hidePopup();
   else
      showPopup();
}

void KasItem::paintFrame( QPainter *p )
{
   qDrawShadePanel(p, 0, 0, extent(), extent(), colorGroup(), false, 2);

   if ( mouseOver )
      p->setPen(Qt::white);
   else
      p->setPen(Qt::black);

   p->drawRect(0, 0, extent(), extent());
}

void KasItem::paintLabel( QPainter *p, const QString &text )
{
   p->fillRect( 2, 2, extent()-4, 13, QBrush( Qt::black ) );
   p->setPen( Qt::white );

   if ( fontMetrics().width( text ) > extent()-4 )
      p->drawText( 2, 2, extent()-4, 12, AlignLeft | AlignVCenter,
		   text );
   else
      p->drawText( 2, 2, extent()-4, 12, AlignCenter, text );
}

void KasItem::paintActiveBg( QPainter *p )
{
   p->drawPixmap( 2, 15, *(kas->activeBg()) );
}

void KasItem::paintInactiveBg( QPainter *p )
{
   if ( !kas->isTransparent() )
       p->drawPixmap( 2, 15, *(kas->inactiveBg()) );
   else
       p->fillRect( 2, 15, extent()-4, extent()-17, kasbar()->backgroundBrush() );
}

void KasItem::paintProgress( QPainter *p, int percent )
{
    double angle = 360*16;
    angle = angle * (percent/100.0L);

    QRect pos;
    pos.setRect( 6, 18, 30, 30 );

    p->setPen( Qt::black );
    p->setBrush( QBrush( Qt::black ) );
    p->drawEllipse( pos );

    p->setPen( Qt::gray );
    p->setBrush( QBrush( Qt::gray ) );
    p->drawPie( pos, 90*16, -angle );

    p->setPen( Qt::white );
    QString text = i18n("%1%");
    p->drawText( pos, AlignCenter, text.arg(percent) );
}

void KasItem::paint( QPainter *p )
{
   //
   // Basic item.
   //
   paintFrame( p );
   paintLabel( p, "Kasbar" );
   paintInactiveBg( p );

   QPixmap pixmap = KGlobal::iconLoader()->loadIcon( "wizard",
						     KIcon::NoGroup,
						     KIcon::SizeMedium );

   if ( !pixmap.isNull() )
      p->drawPixmap( 4, 16, pixmap );
}

void KasItem::paint( QPainter *p, int x, int y )
{
    QSize sz( extent(), extent() );
    QPixmap buff( sz );
//    buff.fill( Qt::red );

    // Paint offscreen buffer
    QPainter op( &buff );
    kas->paintBackground( &op, QRect( QPoint(x,y), sz ) );
    paint( &op );

    // Apply buffer
    p->drawPixmap( x, y, buff );
}

void KasItem::update()
{
   kas->repaintItem( this );
}

void KasItem::update( bool erase )
{
   kas->repaintItem( this, erase );
}

