// Widget for chosing a inptext...
#include "InputCtl.moc"
#include <kapplication.h>
#include <kfiledialog.h>

InputCtl::InputCtl(QString const prompt, QString const initial, QWidget *parent, const char *name):QWidget(parent, name)
{
	int x=0;
	if(prompt!=QString::null) {
		lbl1=new QLabel(prompt,this);
		lbl1->setGeometry(0,0,lbl1->sizeHint().width(),lbl1->height());
		x+=lbl1->width();
	} else
		lbl1=0;
	inptext=new QLineEdit(this);
	if(lbl1!=0)
		lbl1->setBuddy(inptext);
	if(initial!=QString::null)
		inptext->setText(initial);
	inptext->setGeometry(x,0,width()-x,inptext->height());
	inptext->setMaxLength(1024);
}

void InputCtl::resize(int w, int h)
{
	QWidget::resize(w,h);
	if(lbl1!=0)
		inptext->resize(w-lbl1->width(),inptext->height());
	else
		inptext->resize(w,inptext->height());
}

void InputCtl::setGeometry(int x, int y, int w, int h)
{
	move(x,y);
	resize(w,h);
}

QSize InputCtl::sizeHint() const
{
	return QSize(lbl1->sizeHint().width()+inptext->sizeHint().width(),
			lbl1->sizeHint().height()>inptext->sizeHint().height()?
			lbl1->sizeHint().height():inptext->sizeHint().height());
}

InputCtl::~InputCtl()
{
	if(lbl1!=0)
		delete lbl1;
	delete inptext;
}

void InputCtl::setText(QString const txt)
{
	inptext->setText(txt);
}

QString const InputCtl::text()
{
	return inptext->text();
}
