//////////////////////////////////////////////////////////////         
//      $Id: options.h,v 1.16 2001/08/20 14:26:40 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef OPTIONS_H
#define OPTIONS_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <qdir.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qfiledlg.h> 
#include <qgrpbox.h> 
#include <qchkbox.h>
#include <qlayout.h> 
#include <qlined.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qtabdlg.h>

// KDE headers
#include <kapp.h>
#include <kmenubar.h>
#include <kbuttonbox.h> 
#include <kfiledialog.h> 
#include <kcombobox.h>

#include <kpackage.h>

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class Options : public KDialogBase
{
  Q_OBJECT

public:

  Options ( QWidget *parent = 0);
  ~Options(); 

  void restore();
  // show window, setting the buttons

  void setValues();
  // set the dialog to match options values

private:

  bool verifyFL;
  bool PkgRead;
  bool fRemote;
  int  DCache, dc, PCache, pc;

  QVBoxLayout* vl;

  QVBoxLayout* vt;
  QGroupBox *framet;
  QCheckBox *packageHandle[kpinterfaceN];
  QPushButton *locate[kpinterfaceN];

  QGroupBox *hh;
  QCheckBox *huse;
  KComboBox *hosts;

  QVBoxLayout* vb;
  QButtonGroup *bg;
  QRadioButton *disp[4];

  QVBoxLayout*  vc;
  QButtonGroup *bc;
  QRadioButton *dcache[3];

  QVBoxLayout*  vp;
  QButtonGroup *bp;
  QRadioButton *pcache[3];

  QVBoxLayout* vr;
  QGroupBox *framer;
  QCheckBox *pkgRead;

  QVBoxLayout* vf;
  QGroupBox *framem;
  QCheckBox *valid;

  QCheckBox *ssh;

public slots:
    void scanLocates();
    void apply_slot();
    void cancel_slot();
    void PDCache(int);
    void PPCache(int);

private slots:
    void insHosts();
    void useRemote(); 
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class Opts
{
public:
  void readSettings(QString initHost = "");
  void writeSettings();

  QStringList hostList;
  // list of hosts to choose from

  bool VerifyFL;
  // config: verify the file list

  bool PkgRead;
  // read information about uninstalled packages from each RPM file itself

  bool handlePackage[kpinterfaceN];

  enum {INSTALLED, UPDATED, NEW, ALL};
  enum {ALWAYS, SESSION, NEVER};

  int DCache;
  // how much to cache uninstall package directories

  int PCache;
  // how much to cache uninstall packages

  bool useSSH;

  Opts(QString initHost);
  ~Opts();
};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif 
