/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.ccache.a2;
import sun.security.krb5.internal.l;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class HostAddresses
implements Cloneable {
    public l[] addresses;

    public HostAddresses(l[] lArray) {
        this.addresses = lArray;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new l[1];
        this.addresses[0] = new l();
    }

    private HostAddresses(int n2) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException("TBD: Bad name");
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        l[] lArray = new l[inetAddressArray.length];
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            lArray[n2] = new l(inetAddressArray[n2]);
            ++n2;
        }
        this.addresses = lArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new l[this.addresses.length];
            int n2 = 0;
            while (n2 < this.addresses.length) {
                hostAddresses.addresses[n2] = (l)this.addresses[n2].clone();
                ++n2;
            }
        }
        return hostAddresses;
    }

    public boolean inList(l l2) {
        if (this.addresses != null) {
            int n2 = 0;
            while (n2 < this.addresses.length) {
                if (this.addresses[n2].a(l2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.addresses.length) {
                if (!this.addresses[n2].a(hostAddresses.addresses[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector vector = new Vector();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new l(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new l[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            int n2 = 0;
            while (n2 < this.addresses.length) {
                derOutputStream.write(this.addresses[n2].d());
                ++n2;
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(a2 a22) throws IOException {
        a22.a(this.addresses.length);
        int n2 = 0;
        while (n2 < this.addresses.length) {
            a22.b(this.addresses[n2].a);
            a22.a(this.addresses[n2].b.length);
            a22.write(this.addresses[n2].b, 0, this.addresses[n2].b.length);
            ++n2;
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.addresses.length);
        int n2 = 0;
        while (n2 < this.addresses.length) {
            try {
                if (this.addresses[n2].a == 2) {
                    arrayList.add(this.addresses[n2].c());
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            ++n2;
        }
        Object[] objectArray = new InetAddress[arrayList.size()];
        return (InetAddress[])arrayList.toArray(objectArray);
    }
}

